/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.proxy.service.metadata;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.rocketmq.auth.authentication.model.Subject;
import org.apache.rocketmq.auth.authentication.model.User;
import org.apache.rocketmq.auth.authorization.model.Acl;
import org.apache.rocketmq.broker.auth.converter.AclConverter;
import org.apache.rocketmq.broker.auth.converter.UserConverter;
import org.apache.rocketmq.client.impl.mqclient.MQClientAPIFactory;
import org.apache.rocketmq.common.attribute.TopicMessageType;
import org.apache.rocketmq.common.thread.ThreadPoolMonitor;
import org.apache.rocketmq.common.utils.AbstractStartAndShutdown;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.proxy.common.AbstractCacheLoader;
import org.apache.rocketmq.proxy.common.ProxyContext;
import org.apache.rocketmq.proxy.config.ConfigurationManager;
import org.apache.rocketmq.proxy.config.ProxyConfig;
import org.apache.rocketmq.proxy.service.metadata.MetadataService;
import org.apache.rocketmq.proxy.service.route.TopicRouteHelper;
import org.apache.rocketmq.proxy.service.route.TopicRouteService;
import org.apache.rocketmq.remoting.protocol.body.AclInfo;
import org.apache.rocketmq.remoting.protocol.body.UserInfo;
import org.apache.rocketmq.remoting.protocol.route.BrokerData;
import org.apache.rocketmq.remoting.protocol.statictopic.TopicConfigAndQueueMapping;
import org.apache.rocketmq.remoting.protocol.subscription.SubscriptionGroupConfig;

public class ClusterMetadataService
extends AbstractStartAndShutdown
implements MetadataService {
    protected static final Logger log = LoggerFactory.getLogger((String)"RocketmqProxy");
    private static final long DEFAULT_TIMEOUT = 3000L;
    private final TopicRouteService topicRouteService;
    private final MQClientAPIFactory mqClientAPIFactory;
    protected final ThreadPoolExecutor cacheRefreshExecutor;
    protected final LoadingCache<String, TopicConfigAndQueueMapping> topicConfigCache;
    protected static final TopicConfigAndQueueMapping EMPTY_TOPIC_CONFIG = new TopicConfigAndQueueMapping();
    protected final LoadingCache<String, SubscriptionGroupConfig> subscriptionGroupConfigCache;
    protected static final SubscriptionGroupConfig EMPTY_SUBSCRIPTION_GROUP_CONFIG = new SubscriptionGroupConfig();
    protected final LoadingCache<String, User> userCache;
    protected static final User EMPTY_USER = new User();
    protected final LoadingCache<String, Acl> aclCache;
    protected static final Acl EMPTY_ACL = new Acl();
    protected final Random random = new Random();

    public ClusterMetadataService(TopicRouteService topicRouteService, MQClientAPIFactory mqClientAPIFactory) {
        this.topicRouteService = topicRouteService;
        this.mqClientAPIFactory = mqClientAPIFactory;
        ProxyConfig config = ConfigurationManager.getProxyConfig();
        this.cacheRefreshExecutor = ThreadPoolMonitor.createAndMonitor((int)config.getMetadataThreadPoolNums(), (int)config.getMetadataThreadPoolNums(), (long)60000L, (TimeUnit)TimeUnit.MILLISECONDS, (String)"MetadataCacheRefresh", (int)config.getMetadataThreadPoolQueueCapacity());
        this.topicConfigCache = CacheBuilder.newBuilder().maximumSize((long)config.getTopicConfigCacheMaxNum()).expireAfterAccess((long)config.getTopicConfigCacheExpiredSeconds(), TimeUnit.SECONDS).refreshAfterWrite((long)config.getTopicConfigCacheRefreshSeconds(), TimeUnit.SECONDS).build((CacheLoader)new ClusterTopicConfigCacheLoader());
        this.subscriptionGroupConfigCache = CacheBuilder.newBuilder().maximumSize((long)config.getSubscriptionGroupConfigCacheMaxNum()).expireAfterAccess((long)config.getSubscriptionGroupConfigCacheExpiredSeconds(), TimeUnit.SECONDS).refreshAfterWrite((long)config.getSubscriptionGroupConfigCacheRefreshSeconds(), TimeUnit.SECONDS).build((CacheLoader)new ClusterSubscriptionGroupConfigCacheLoader());
        this.userCache = CacheBuilder.newBuilder().maximumSize((long)config.getUserCacheMaxNum()).expireAfterAccess((long)config.getUserCacheExpiredSeconds(), TimeUnit.SECONDS).refreshAfterWrite((long)config.getUserCacheRefreshSeconds(), TimeUnit.SECONDS).build((CacheLoader)new ClusterUserCacheLoader());
        this.aclCache = CacheBuilder.newBuilder().maximumSize((long)config.getAclCacheMaxNum()).expireAfterAccess((long)config.getAclCacheExpiredSeconds(), TimeUnit.SECONDS).refreshAfterWrite((long)config.getAclCacheRefreshSeconds(), TimeUnit.SECONDS).build((CacheLoader)new ClusterAclCacheLoader());
        this.init();
    }

    protected void init() {
        this.appendShutdown(this.cacheRefreshExecutor::shutdown);
    }

    @Override
    public TopicMessageType getTopicMessageType(ProxyContext ctx, String topic) {
        TopicConfigAndQueueMapping topicConfigAndQueueMapping;
        try {
            topicConfigAndQueueMapping = (TopicConfigAndQueueMapping)this.topicConfigCache.get((Object)topic);
        }
        catch (Exception e) {
            return TopicMessageType.UNSPECIFIED;
        }
        if (topicConfigAndQueueMapping.equals((Object)EMPTY_TOPIC_CONFIG)) {
            return TopicMessageType.UNSPECIFIED;
        }
        return topicConfigAndQueueMapping.getTopicMessageType();
    }

    @Override
    public SubscriptionGroupConfig getSubscriptionGroupConfig(ProxyContext ctx, String group) {
        SubscriptionGroupConfig config;
        try {
            config = (SubscriptionGroupConfig)this.subscriptionGroupConfigCache.get((Object)group);
        }
        catch (Exception e) {
            return null;
        }
        if (config == EMPTY_SUBSCRIPTION_GROUP_CONFIG) {
            return null;
        }
        return config;
    }

    @Override
    public CompletableFuture<User> getUser(ProxyContext ctx, String username) {
        CompletableFuture<User> result = new CompletableFuture<User>();
        try {
            User user = (User)this.userCache.get((Object)username);
            if (user == EMPTY_USER) {
                user = null;
            }
            result.complete(user);
        }
        catch (Exception e) {
            result.completeExceptionally(e);
        }
        return result;
    }

    @Override
    public CompletableFuture<Acl> getAcl(ProxyContext ctx, Subject subject) {
        CompletableFuture<Acl> result = new CompletableFuture<Acl>();
        try {
            Acl acl = (Acl)this.aclCache.get((Object)subject.getSubjectKey());
            if (acl == EMPTY_ACL) {
                acl = null;
            }
            result.complete(acl);
        }
        catch (Exception e) {
            result.completeExceptionally(e);
        }
        return result;
    }

    protected Optional<BrokerData> findOneBroker(String topic) throws Exception {
        try {
            List brokerDatas = this.topicRouteService.getAllMessageQueueView(ProxyContext.createForInner(this.getClass()), topic).getTopicRouteData().getBrokerDatas();
            int skipNum = this.random.nextInt(brokerDatas.size());
            return brokerDatas.stream().skip(skipNum).findFirst();
        }
        catch (Exception e) {
            if (TopicRouteHelper.isTopicNotExistError(e)) {
                return Optional.empty();
            }
            throw e;
        }
    }

    protected class ClusterAclCacheLoader
    extends AbstractCacheLoader<String, Acl> {
        public ClusterAclCacheLoader() {
            super(ClusterMetadataService.this.cacheRefreshExecutor);
        }

        @Override
        protected Acl getDirectly(String subject) throws Exception {
            ProxyConfig config = ConfigurationManager.getProxyConfig();
            String clusterName = config.getRocketMQClusterName();
            Optional<BrokerData> brokerDataOptional = ClusterMetadataService.this.findOneBroker(clusterName);
            if (brokerDataOptional.isPresent()) {
                String brokerAddress = brokerDataOptional.get().selectBrokerAddr();
                AclInfo aclInfo = ClusterMetadataService.this.mqClientAPIFactory.getClient().getAcl(brokerAddress, subject, 3000L);
                if (aclInfo == null) {
                    return EMPTY_ACL;
                }
                return AclConverter.convertAcl((AclInfo)aclInfo);
            }
            return EMPTY_ACL;
        }

        @Override
        protected void onErr(String key, Exception e) {
            log.error("load user failed. username:{}", (Object)key, (Object)e);
        }
    }

    protected class ClusterUserCacheLoader
    extends AbstractCacheLoader<String, User> {
        public ClusterUserCacheLoader() {
            super(ClusterMetadataService.this.cacheRefreshExecutor);
        }

        @Override
        protected User getDirectly(String username) throws Exception {
            ProxyConfig config = ConfigurationManager.getProxyConfig();
            String clusterName = config.getRocketMQClusterName();
            Optional<BrokerData> brokerDataOptional = ClusterMetadataService.this.findOneBroker(clusterName);
            if (brokerDataOptional.isPresent()) {
                String brokerAddress = brokerDataOptional.get().selectBrokerAddr();
                UserInfo userInfo = ClusterMetadataService.this.mqClientAPIFactory.getClient().getUser(brokerAddress, username, 3000L);
                if (userInfo == null) {
                    return EMPTY_USER;
                }
                return UserConverter.convertUser((UserInfo)userInfo);
            }
            return EMPTY_USER;
        }

        @Override
        protected void onErr(String key, Exception e) {
            log.error("load user failed. username:{}", (Object)key, (Object)e);
        }
    }

    protected class ClusterTopicConfigCacheLoader
    extends AbstractCacheLoader<String, TopicConfigAndQueueMapping> {
        public ClusterTopicConfigCacheLoader() {
            super(ClusterMetadataService.this.cacheRefreshExecutor);
        }

        @Override
        protected TopicConfigAndQueueMapping getDirectly(String topic) throws Exception {
            Optional<BrokerData> brokerDataOptional = ClusterMetadataService.this.findOneBroker(topic);
            if (brokerDataOptional.isPresent()) {
                String brokerAddress = brokerDataOptional.get().selectBrokerAddr();
                return ClusterMetadataService.this.mqClientAPIFactory.getClient().getTopicConfig(brokerAddress, topic, 3000L);
            }
            return EMPTY_TOPIC_CONFIG;
        }

        @Override
        protected void onErr(String key, Exception e) {
            log.error("load topic config failed. topic:{}", (Object)key, (Object)e);
        }
    }

    protected class ClusterSubscriptionGroupConfigCacheLoader
    extends AbstractCacheLoader<String, SubscriptionGroupConfig> {
        public ClusterSubscriptionGroupConfigCacheLoader() {
            super(ClusterMetadataService.this.cacheRefreshExecutor);
        }

        @Override
        protected SubscriptionGroupConfig getDirectly(String consumerGroup) throws Exception {
            ProxyConfig config = ConfigurationManager.getProxyConfig();
            String clusterName = config.getRocketMQClusterName();
            Optional<BrokerData> brokerDataOptional = ClusterMetadataService.this.findOneBroker(clusterName);
            if (brokerDataOptional.isPresent()) {
                String brokerAddress = brokerDataOptional.get().selectBrokerAddr();
                return ClusterMetadataService.this.mqClientAPIFactory.getClient().getSubscriptionGroupConfig(brokerAddress, consumerGroup, 3000L);
            }
            return EMPTY_SUBSCRIPTION_GROUP_CONFIG;
        }

        @Override
        protected void onErr(String consumerGroup, Exception e) {
            log.error("load subscription config failed. consumerGroup:{}", (Object)consumerGroup, (Object)e);
        }
    }
}

