/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.schema;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONFactory;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.annotation.JSONField;
import com.alibaba.fastjson2.schema.AllOf;
import com.alibaba.fastjson2.schema.Any;
import com.alibaba.fastjson2.schema.AnyOf;
import com.alibaba.fastjson2.schema.JSONSchema;
import com.alibaba.fastjson2.schema.OneOf;
import com.alibaba.fastjson2.schema.StringSchema;
import com.alibaba.fastjson2.schema.UnresolvedReference;
import com.alibaba.fastjson2.schema.ValidateResult;
import com.alibaba.fastjson2.util.Fnv;
import com.alibaba.fastjson2.writer.FieldWriter;
import com.alibaba.fastjson2.writer.ObjectWriter;
import com.alibaba.fastjson2.writer.ObjectWriterAdapter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;

public final class ObjectSchema
extends JSONSchema {
    final boolean typed;
    final Map<String, JSONSchema> definitions;
    final Map<String, JSONSchema> defs;
    final Map<String, JSONSchema> properties;
    final Set<String> required;
    final boolean additionalProperties;
    final JSONSchema additionalPropertySchema;
    final long[] requiredHashCode;
    final PatternProperty[] patternProperties;
    final JSONSchema propertyNames;
    final int minProperties;
    final int maxProperties;
    final Map<String, String[]> dependentRequired;
    final Map<Long, long[]> dependentRequiredHashCodes;
    final Map<String, JSONSchema> dependentSchemas;
    final Map<Long, JSONSchema> dependentSchemasHashMapping;
    final JSONSchema ifSchema;
    final JSONSchema thenSchema;
    final JSONSchema elseSchema;
    final AllOf allOf;
    final AnyOf anyOf;
    final OneOf oneOf;
    transient List<UnresolvedReference.ResolveTask> resolveTasks;

    public ObjectSchema(JSONObject input) {
        this(input, null);
    }

    public ObjectSchema(JSONObject input, JSONSchema root) {
        super(input);
        JSONObject dependentSchemas;
        JSONArray required;
        JSONObject jSONObject;
        JSONObject jSONObject2;
        JSONObject defs;
        this.typed = "object".equalsIgnoreCase(input.getString("type"));
        this.properties = new LinkedHashMap<String, JSONSchema>();
        this.definitions = new LinkedHashMap<String, JSONSchema>();
        this.defs = new LinkedHashMap<String, JSONSchema>();
        JSONObject definitions = input.getJSONObject("definitions");
        if (definitions != null) {
            for (Map.Entry entry : definitions.entrySet()) {
                String string = (String)entry.getKey();
                JSONObject entryValue = (JSONObject)entry.getValue();
                JSONSchema schema = JSONSchema.of(entryValue, root == null ? this : root);
                this.definitions.put(string, schema);
            }
        }
        if ((defs = input.getJSONObject("$defs")) != null) {
            for (Map.Entry entry : defs.entrySet()) {
                String entryKey = (String)entry.getKey();
                JSONObject entryValue = (JSONObject)entry.getValue();
                JSONSchema jSONSchema = JSONSchema.of(entryValue, root == null ? this : root);
                this.defs.put(entryKey, jSONSchema);
            }
            if (this.resolveTasks != null) {
                for (UnresolvedReference.ResolveTask resolveTask : this.resolveTasks) {
                    resolveTask.resolve(this);
                }
            }
        }
        if ((jSONObject2 = input.getJSONObject("properties")) != null) {
            for (Map.Entry entry : jSONObject2.entrySet()) {
                String entryKey = (String)entry.getKey();
                Object v = entry.getValue();
                JSONSchema schema = v instanceof Boolean ? ((Boolean)v != false ? Any.INSTANCE : Any.NOT_ANY) : (v instanceof JSONSchema ? (JSONSchema)v : JSONSchema.of((JSONObject)v, root == null ? this : root));
                this.properties.put(entryKey, schema);
                if (!(schema instanceof UnresolvedReference)) continue;
                String refName = ((UnresolvedReference)schema).refName;
                UnresolvedReference.PropertyResolveTask task = new UnresolvedReference.PropertyResolveTask(this.properties, entryKey, refName);
                JSONSchema resolveRoot = root == null ? this : root;
                resolveRoot.addResolveTask(task);
            }
        }
        if ((jSONObject = input.getJSONObject("patternProperties")) != null) {
            this.patternProperties = new PatternProperty[jSONObject.size()];
            int index = 0;
            for (Map.Entry entry : jSONObject.entrySet()) {
                String entryKey = (String)entry.getKey();
                Object entryValue = entry.getValue();
                JSONSchema schema = entryValue instanceof Boolean ? ((Boolean)entryValue != false ? Any.INSTANCE : Any.NOT_ANY) : JSONSchema.of((JSONObject)entryValue, root == null ? this : root);
                this.patternProperties[index++] = new PatternProperty(Pattern.compile(entryKey), schema);
            }
        } else {
            this.patternProperties = new PatternProperty[0];
        }
        if ((required = input.getJSONArray("required")) == null || required.isEmpty()) {
            this.required = Collections.emptySet();
            this.requiredHashCode = new long[0];
        } else {
            int i;
            this.required = new LinkedHashSet<String>(required.size());
            for (i = 0; i < required.size(); ++i) {
                this.required.add(required.getString(i));
            }
            this.requiredHashCode = new long[this.required.size()];
            i = 0;
            for (String item : this.required) {
                this.requiredHashCode[i++] = Fnv.hashCode64(item);
            }
        }
        Object additionalProperties = input.get("additionalProperties");
        if (additionalProperties instanceof Boolean) {
            this.additionalPropertySchema = null;
            this.additionalProperties = (Boolean)additionalProperties;
        } else if (additionalProperties instanceof JSONObject) {
            this.additionalPropertySchema = JSONSchema.of((JSONObject)additionalProperties, root);
            this.additionalProperties = false;
        } else {
            this.additionalPropertySchema = null;
            this.additionalProperties = true;
        }
        Object object = input.get("propertyNames");
        this.propertyNames = object == null ? null : (object instanceof Boolean ? ((Boolean)object != false ? Any.INSTANCE : Any.NOT_ANY) : new StringSchema((JSONObject)object));
        this.minProperties = input.getIntValue("minProperties", -1);
        this.maxProperties = input.getIntValue("maxProperties", -1);
        JSONObject dependentRequired = input.getJSONObject("dependentRequired");
        if (dependentRequired != null && !dependentRequired.isEmpty()) {
            this.dependentRequired = new LinkedHashMap<String, String[]>(dependentRequired.size(), 1.0f);
            this.dependentRequiredHashCodes = new LinkedHashMap<Long, long[]>(dependentRequired.size(), 1.0f);
            Set keys = dependentRequired.keySet();
            for (String key : keys) {
                String[] dependentRequiredProperties = dependentRequired.getObject(key, String[].class, new JSONReader.Feature[0]);
                long[] dependentRequiredPropertiesHash = new long[dependentRequiredProperties.length];
                for (int i = 0; i < dependentRequiredProperties.length; ++i) {
                    dependentRequiredPropertiesHash[i] = Fnv.hashCode64(dependentRequiredProperties[i]);
                }
                this.dependentRequired.put(key, dependentRequiredProperties);
                this.dependentRequiredHashCodes.put(Fnv.hashCode64(key), dependentRequiredPropertiesHash);
            }
        } else {
            this.dependentRequired = null;
            this.dependentRequiredHashCodes = null;
        }
        if ((dependentSchemas = input.getJSONObject("dependentSchemas")) != null && !dependentSchemas.isEmpty()) {
            this.dependentSchemas = new LinkedHashMap<String, JSONSchema>(dependentSchemas.size(), 1.0f);
            this.dependentSchemasHashMapping = new LinkedHashMap<Long, JSONSchema>(dependentSchemas.size(), 1.0f);
            Set keys = dependentSchemas.keySet();
            for (String key : keys) {
                JSONSchema dependentSchema = dependentSchemas.getObject(key, JSONSchema::of);
                this.dependentSchemas.put(key, dependentSchema);
                this.dependentSchemasHashMapping.put(Fnv.hashCode64(key), dependentSchema);
            }
        } else {
            this.dependentSchemas = null;
            this.dependentSchemasHashMapping = null;
        }
        this.ifSchema = input.getObject("if", JSONSchema::of);
        this.elseSchema = input.getObject("else", JSONSchema::of);
        this.thenSchema = input.getObject("then", JSONSchema::of);
        this.allOf = ObjectSchema.allOf(input, null);
        this.anyOf = ObjectSchema.anyOf(input, null);
        this.oneOf = ObjectSchema.oneOf(input, null);
    }

    @Override
    void addResolveTask(UnresolvedReference.ResolveTask task) {
        if (this.resolveTasks == null) {
            this.resolveTasks = new ArrayList<UnresolvedReference.ResolveTask>();
        }
        this.resolveTasks.add(task);
    }

    @Override
    public JSONSchema.Type getType() {
        return JSONSchema.Type.Object;
    }

    /*
     * WARNING - void declaration
     */
    public ValidateResult validate(Map map) {
        ValidateResult result;
        String strKey;
        for (String string : this.required) {
            if (map.containsKey(string)) continue;
            return new ValidateResult(false, "required %s", string);
        }
        for (Map.Entry entry : this.properties.entrySet()) {
            ValidateResult validateResult;
            String key = (String)entry.getKey();
            JSONSchema jSONSchema = (JSONSchema)entry.getValue();
            Object propertyValue = map.get(key);
            if (propertyValue == null && !map.containsKey(key) || (validateResult = jSONSchema.validate(propertyValue)).isSuccess()) continue;
            return new ValidateResult(validateResult, "property %s invalid", key);
        }
        for (Iterator<Object> iterator : this.patternProperties) {
            for (Map.Entry entry : map.entrySet()) {
                ValidateResult result3;
                Object entryKey = entry.getKey();
                if (!(entryKey instanceof String) || !((PatternProperty)((Object)iterator)).pattern.matcher(strKey = (String)entryKey).find() || (result3 = ((PatternProperty)((Object)iterator)).schema.validate(entry.getValue())).isSuccess()) continue;
                return result3;
            }
        }
        if (!this.additionalProperties) {
            block4: for (Map.Entry entry : map.entrySet()) {
                void var7_37;
                Object key = entry.getKey();
                if (this.properties.containsKey(key)) continue;
                PatternProperty[] patternPropertyArray = this.patternProperties;
                int propertyValue = patternPropertyArray.length;
                boolean bl = false;
                while (var7_37 < propertyValue) {
                    PatternProperty patternProperty = patternPropertyArray[var7_37];
                    if (key instanceof String && patternProperty.pattern.matcher(strKey = (String)key).find()) continue block4;
                    ++var7_37;
                }
                if (this.additionalPropertySchema != null) {
                    ValidateResult validateResult = this.additionalPropertySchema.validate(entry.getValue());
                    if (validateResult.isSuccess()) continue;
                    return validateResult;
                }
                return new ValidateResult(false, "add additionalProperties %s", key);
            }
        }
        if (this.propertyNames != null) {
            for (Object object : map.keySet()) {
                ValidateResult result5 = this.propertyNames.validate(object);
                if (result5.isSuccess()) continue;
                return FAIL_PROPERTY_NAME;
            }
        }
        if (this.minProperties >= 0 && map.size() < this.minProperties) {
            return new ValidateResult(false, "minProperties not match, expect %s, but %s", this.minProperties, map.size());
        }
        if (this.maxProperties >= 0 && map.size() > this.maxProperties) {
            return new ValidateResult(false, "maxProperties not match, expect %s, but %s", this.maxProperties, map.size());
        }
        if (this.dependentRequired != null) {
            for (Map.Entry entry : this.dependentRequired.entrySet()) {
                String[] dependentRequiredProperties;
                String key = (String)entry.getKey();
                Object v = map.get(key);
                if (v == null) continue;
                for (String dependentRequiredProperty : dependentRequiredProperties = (String[])entry.getValue()) {
                    if (map.containsKey(dependentRequiredProperty)) continue;
                    return new ValidateResult(false, "property %s, dependentRequired property %s", key, dependentRequiredProperty);
                }
            }
        }
        if (this.dependentSchemas != null) {
            for (Map.Entry entry : this.dependentSchemas.entrySet()) {
                JSONSchema schema;
                ValidateResult validateResult;
                String key = (String)entry.getKey();
                Object v = map.get(key);
                if (v == null || (validateResult = (schema = (JSONSchema)entry.getValue()).validate(map)).isSuccess()) continue;
                return validateResult;
            }
        }
        if (this.ifSchema != null) {
            ValidateResult validateResult;
            ValidateResult ifResult = this.ifSchema.validate(map);
            if (ifResult == SUCCESS) {
                ValidateResult validateResult2;
                if (this.thenSchema != null && !(validateResult2 = this.thenSchema.validate(map)).isSuccess()) {
                    return validateResult2;
                }
            } else if (this.elseSchema != null && !(validateResult = this.elseSchema.validate(map)).isSuccess()) {
                return validateResult;
            }
        }
        if (this.allOf != null && !(result = this.allOf.validate(map)).isSuccess()) {
            return result;
        }
        if (this.anyOf != null && !(result = this.anyOf.validate(map)).isSuccess()) {
            return result;
        }
        if (this.oneOf != null && !(result = this.oneOf.validate(map)).isSuccess()) {
            return result;
        }
        return SUCCESS;
    }

    @Override
    public ValidateResult validate(Object value) {
        ValidateResult result;
        Object fieldValue;
        if (value == null) {
            return this.typed ? FAIL_INPUT_NULL : SUCCESS;
        }
        if (value instanceof Map) {
            return this.validate((Map)value);
        }
        Class<?> valueClass = value.getClass();
        ObjectWriter objectWriter = JSONFactory.getDefaultObjectWriterProvider().getObjectWriter(valueClass);
        if (!(objectWriter instanceof ObjectWriterAdapter)) {
            return this.typed ? new ValidateResult(false, "expect type %s, but %s", new Object[]{JSONSchema.Type.Object, valueClass}) : SUCCESS;
        }
        for (int i = 0; i < this.requiredHashCode.length; ++i) {
            long nameHash = this.requiredHashCode[i];
            FieldWriter fieldWriter = objectWriter.getFieldWriter(nameHash);
            fieldValue = null;
            if (fieldWriter != null) {
                fieldValue = fieldWriter.getFieldValue(value);
            }
            if (fieldValue != null) continue;
            String fieldName = null;
            int j = 0;
            for (String itemName : this.required) {
                if (j == i) {
                    fieldName = itemName;
                }
                ++j;
            }
            return new ValidateResult(false, "required property %s", fieldName);
        }
        for (Map.Entry<String, JSONSchema> entry : this.properties.entrySet()) {
            ValidateResult result2;
            Object propertyValue;
            String key = entry.getKey();
            long keyHash = Fnv.hashCode64(key);
            JSONSchema schema = entry.getValue();
            FieldWriter fieldWriter = objectWriter.getFieldWriter(keyHash);
            if (fieldWriter == null || (propertyValue = fieldWriter.getFieldValue(value)) == null || (result2 = schema.validate(propertyValue)).isSuccess()) continue;
            return result2;
        }
        if (this.minProperties >= 0 || this.maxProperties >= 0) {
            int fieldValueCount = 0;
            List<FieldWriter> fieldWriters = objectWriter.getFieldWriters();
            for (FieldWriter fieldWriter : fieldWriters) {
                fieldValue = fieldWriter.getFieldValue(value);
                if (fieldValue == null) continue;
                ++fieldValueCount;
            }
            if (this.minProperties >= 0 && fieldValueCount < this.minProperties) {
                return new ValidateResult(false, "minProperties not match, expect %s, but %s", this.minProperties, fieldValueCount);
            }
            if (this.maxProperties >= 0 && fieldValueCount > this.maxProperties) {
                return new ValidateResult(false, "maxProperties not match, expect %s, but %s", this.maxProperties, fieldValueCount);
            }
        }
        if (this.dependentRequiredHashCodes != null) {
            int propertyIndex = 0;
            for (Map.Entry<Long, long[]> entry : this.dependentRequiredHashCodes.entrySet()) {
                Long keyHash = entry.getKey();
                long[] dependentRequiredProperties = entry.getValue();
                FieldWriter fieldWriter = objectWriter.getFieldWriter(keyHash);
                Object fieldValue2 = fieldWriter.getFieldValue(value);
                if (fieldValue2 == null) {
                    ++propertyIndex;
                    continue;
                }
                for (int requiredIndex = 0; requiredIndex < dependentRequiredProperties.length; ++requiredIndex) {
                    long dependentRequiredHash = dependentRequiredProperties[requiredIndex];
                    FieldWriter dependentFieldWriter = objectWriter.getFieldWriter(dependentRequiredHash);
                    if (dependentFieldWriter != null && dependentFieldWriter.getFieldValue(value) != null) continue;
                    int i = 0;
                    String property = null;
                    String dependentRequiredProperty = null;
                    Iterator<Map.Entry<String, String[]>> it = this.dependentRequired.entrySet().iterator();
                    while (it.hasNext()) {
                        if (propertyIndex == i) {
                            Map.Entry<String, String[]> dependentRequiredEntry = it.next();
                            property = dependentRequiredEntry.getKey();
                            dependentRequiredProperty = dependentRequiredEntry.getValue()[requiredIndex];
                        }
                        ++i;
                    }
                    return new ValidateResult(false, "property %s, dependentRequired property %s", property, dependentRequiredProperty);
                }
                ++propertyIndex;
            }
        }
        if (this.dependentSchemasHashMapping != null) {
            for (Map.Entry<Long, JSONSchema> entry : this.dependentSchemasHashMapping.entrySet()) {
                JSONSchema schema;
                ValidateResult result3;
                Long keyHash = entry.getKey();
                FieldWriter fieldWriter = objectWriter.getFieldWriter(keyHash);
                if (fieldWriter == null || fieldWriter.getFieldValue(value) == null || (result3 = (schema = entry.getValue()).validate(value)).isSuccess()) continue;
                return result3;
            }
        }
        if (this.ifSchema != null) {
            ValidateResult elseResult;
            ValidateResult ifResult = this.ifSchema.validate(value);
            if (ifResult.isSuccess()) {
                ValidateResult thenResult;
                if (this.thenSchema != null && !(thenResult = this.thenSchema.validate(value)).isSuccess()) {
                    return thenResult;
                }
            } else if (this.elseSchema != null && !(elseResult = this.elseSchema.validate(value)).isSuccess()) {
                return elseResult;
            }
        }
        if (this.allOf != null && !(result = this.allOf.validate(value)).isSuccess()) {
            return result;
        }
        if (this.anyOf != null && !(result = this.anyOf.validate(value)).isSuccess()) {
            return result;
        }
        if (this.oneOf != null && !(result = this.oneOf.validate(value)).isSuccess()) {
            return result;
        }
        return SUCCESS;
    }

    public Map<String, JSONSchema> getProperties() {
        return this.properties;
    }

    public JSONSchema getProperty(String key) {
        return this.properties.get(key);
    }

    public Set<String> getRequired() {
        return this.required;
    }

    @Override
    @JSONField(value=true)
    public JSONObject toJSONObject() {
        JSONObject object = new JSONObject();
        object.put("type", "object");
        if (this.title != null) {
            object.put("title", this.title);
        }
        if (this.description != null) {
            object.put("description", this.description);
        }
        if (!this.definitions.isEmpty()) {
            object.put("definitions", this.definitions);
        }
        if (!this.defs.isEmpty()) {
            object.put("defs", this.defs);
        }
        if (!this.properties.isEmpty()) {
            object.put("properties", this.properties);
        }
        if (!this.required.isEmpty()) {
            object.put("required", this.required);
        }
        if (!this.additionalProperties) {
            if (this.additionalPropertySchema != null) {
                object.put("additionalProperties", this.additionalPropertySchema);
            } else {
                object.put("additionalProperties", this.additionalProperties);
            }
        }
        if (this.patternProperties != null && this.patternProperties.length != 0) {
            object.put("patternProperties", this.patternProperties);
        }
        if (this.propertyNames != null) {
            object.put("propertyNames", this.propertyNames);
        }
        if (this.minProperties != -1) {
            object.put("minProperties", this.minProperties);
        }
        if (this.maxProperties != -1) {
            object.put("maxProperties", this.maxProperties);
        }
        if (this.dependentRequired != null && !this.dependentRequired.isEmpty()) {
            object.put("dependentRequired", this.dependentRequired);
        }
        if (this.dependentSchemas != null && !this.dependentSchemas.isEmpty()) {
            object.put("dependentSchemas", this.dependentSchemas);
        }
        if (this.ifSchema != null) {
            object.put("if", this.ifSchema);
        }
        if (this.thenSchema != null) {
            object.put("then", this.thenSchema);
        }
        if (this.elseSchema != null) {
            object.put("else", this.elseSchema);
        }
        if (this.allOf != null) {
            object.put("allOf", this.allOf);
        }
        if (this.anyOf != null) {
            object.put("anyOf", this.anyOf);
        }
        if (this.oneOf != null) {
            object.put("oneOf", this.oneOf);
        }
        return object;
    }

    @Override
    public void accept(Predicate<JSONSchema> v) {
        if (v.test(this)) {
            this.properties.values().forEach(v::test);
        }
    }

    public JSONSchema getDefs(String def) {
        return this.defs.get(def);
    }

    static final class PatternProperty {
        final Pattern pattern;
        final JSONSchema schema;

        public PatternProperty(Pattern pattern, JSONSchema schema) {
            this.pattern = pattern;
            this.schema = schema;
        }
    }
}

