/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.common.logging;

import com.google.common.io.CharStreams;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import org.apache.rocketmq.logging.ch.qos.logback.classic.joran.JoranConfigurator;
import org.apache.rocketmq.logging.ch.qos.logback.core.Context;
import org.apache.rocketmq.logging.ch.qos.logback.core.joran.spi.JoranException;

public class JoranConfiguratorExt
extends JoranConfigurator {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InputStream transformXml(InputStream in) throws IOException {
        try {
            String str = CharStreams.toString((Readable)new InputStreamReader(in, StandardCharsets.UTF_8));
            str = str.replace("\"ch.qos.logback", "\"org.apache.rocketmq.logging.ch.qos.logback");
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(str.getBytes(StandardCharsets.UTF_8));
            return byteArrayInputStream;
        }
        finally {
            if (null != in) {
                in.close();
            }
        }
    }

    public final void doConfigure0(URL url) throws JoranException {
        InputStream in = null;
        try {
            JoranConfiguratorExt.informContextOfURLUsedForConfiguration((Context)this.getContext(), (URL)url);
            URLConnection urlConnection = url.openConnection();
            urlConnection.setUseCaches(false);
            InputStream temp = urlConnection.getInputStream();
            in = this.transformXml(temp);
            this.doConfigure(in, url.toExternalForm());
        }
        catch (IOException ioe) {
            String errMsg = "Could not open URL [" + url + "].";
            this.addError(errMsg, ioe);
            throw new JoranException(errMsg, (Throwable)ioe);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ioe) {
                    String errMsg = "Could not close input stream";
                    this.addError(errMsg, ioe);
                    throw new JoranException(errMsg, (Throwable)ioe);
                }
            }
        }
    }
}

