/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.common.security;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SensitiveDataUtil {
    private static boolean hideFlag = true;
    public static final int BANKCARDNO_DATA = 0;
    public static final int IDCARDNO_DATA = 1;
    public static final int PHONENO_DATA = 2;
    public static final int EMAIL_DATA = 3;
    private static final String ID_CARD_REGEXP = "[0-9]{15}|[0-9]{18}|[0-9]{14}X|[0-9]{17}X";
    private static final String BANK_CARD_REGEXP = "[0-9]{8,19}";
    private static final String MAINLAND_PHONE_TEL_REGEXP = "[0-9]{3,4}[-]?[0-9]{7,8}";
    private static final Pattern ID_CARD_PATTERN = Pattern.compile("[0-9]{15}|[0-9]{18}|[0-9]{14}X|[0-9]{17}X");
    private static final Pattern BANK_CARD_PATTERN = Pattern.compile("[0-9]{8,19}");
    private static final Pattern MAINLAND_PHONE_TEL_PATTERN = Pattern.compile("[0-9]{3,4}[-]?[0-9]{7,8}");

    public SensitiveDataUtil(boolean hideFlag) {
        SensitiveDataUtil.setHideFlag(hideFlag);
    }

    public SensitiveDataUtil() {
        SensitiveDataUtil.setHideFlag(true);
    }

    private static boolean isEmail(String email) {
        return email.indexOf(64) > 0;
    }

    public static String alipayLogonIdHide(String logonId) {
        if (!SensitiveDataUtil.needHide()) {
            return logonId;
        }
        if (SensitiveDataUtil.isBlank(logonId)) {
            return logonId;
        }
        if (SensitiveDataUtil.isEmail(logonId)) {
            return SensitiveDataUtil.emailHide(logonId);
        }
        return SensitiveDataUtil.cellphoneHide(logonId);
    }

    public static String alipayLogonIdHideSMS(String logonId) {
        if (!SensitiveDataUtil.needHide()) {
            return logonId;
        }
        if (SensitiveDataUtil.isBlank(logonId)) {
            return logonId;
        }
        if (SensitiveDataUtil.isEmail(logonId)) {
            return SensitiveDataUtil.emailHideSMS(logonId);
        }
        return SensitiveDataUtil.cellphoneHideSMS(logonId);
    }

    public static String nameHide(String name) {
        if (!SensitiveDataUtil.needHide()) {
            return name;
        }
        if (SensitiveDataUtil.isBlank(name)) {
            return name;
        }
        if (name.length() <= 3) {
            return SensitiveDataUtil.customizeHide(name, 0, name.length() - 1, 1);
        }
        if (name.length() > 3 && name.length() <= 6) {
            return SensitiveDataUtil.customizeHide(name, 0, 2, name.length() - 2);
        }
        return SensitiveDataUtil.customizeHide(name, 1, 2, name.length() - 3);
    }

    public static String idCardNoHide(String idCardNo, boolean doValidate) {
        if (!SensitiveDataUtil.needHide()) {
            return idCardNo;
        }
        if (SensitiveDataUtil.isBlank(idCardNo)) {
            return idCardNo;
        }
        if (doValidate && !SensitiveDataUtil.isIdCardNo(idCardNo)) {
            return SensitiveDataUtil.defaultHide(idCardNo);
        }
        return SensitiveDataUtil.customizeHide(idCardNo, 1, 1, idCardNo.length() - 2);
    }

    public static String idCardNoHide(String idCardNo) {
        return SensitiveDataUtil.idCardNoHide(idCardNo, false);
    }

    public static String bankCardNoHide(String bankCardNo, boolean doValidate) {
        if (!SensitiveDataUtil.needHide()) {
            return bankCardNo;
        }
        if (SensitiveDataUtil.isBlank(bankCardNo)) {
            return bankCardNo;
        }
        if (doValidate && !SensitiveDataUtil.isBankCardNo(bankCardNo)) {
            return SensitiveDataUtil.defaultHide(bankCardNo);
        }
        if (bankCardNo.length() >= 16) {
            return SensitiveDataUtil.customizeHide(bankCardNo, 6, 4, bankCardNo.length() - 10);
        }
        return SensitiveDataUtil.defaultHide(bankCardNo);
    }

    public static String bankCardNoHide(String bankCardNo) {
        return SensitiveDataUtil.bankCardNoHide(bankCardNo, false);
    }

    public static String phoneOrTelNoHide(String phoneOrTelNo, boolean doValidate) {
        if (!SensitiveDataUtil.needHide()) {
            return phoneOrTelNo;
        }
        if (SensitiveDataUtil.isBlank(phoneOrTelNo)) {
            return phoneOrTelNo;
        }
        String tmp = phoneOrTelNo.trim();
        if (doValidate && !SensitiveDataUtil.isPhoneOrTelNo(tmp)) {
            return SensitiveDataUtil.defaultHide(tmp);
        }
        if (tmp.charAt(0) == '1') {
            return SensitiveDataUtil.customizeHide(tmp, 3, 2, tmp.length() - 5);
        }
        if (tmp.indexOf("-") > 0) {
            int frontCharNum = tmp.indexOf(45) + 1;
            return SensitiveDataUtil.customizeHide(tmp, frontCharNum, 4, tmp.length() - 4 - frontCharNum);
        }
        return SensitiveDataUtil.defaultHide(tmp);
    }

    public static String phoneOrTelNoHide(String phoneOrTelNo) {
        return SensitiveDataUtil.phoneOrTelNoHide(phoneOrTelNo, false);
    }

    public static String cellphoneHide(String cellphone) {
        if (!SensitiveDataUtil.needHide()) {
            return cellphone;
        }
        if (SensitiveDataUtil.isBlank(cellphone)) {
            return cellphone;
        }
        String tmp = cellphone.trim();
        if (cellphone.length() == 11) {
            return SensitiveDataUtil.customizeHide(tmp, 3, 2, 6);
        }
        int notHideNum = tmp.length() - 4;
        return SensitiveDataUtil.customizeHide(tmp, notHideNum / 2, notHideNum - notHideNum / 2, 4);
    }

    public static String cellphoneHideSMS(String cellphone) {
        if (!SensitiveDataUtil.needHide()) {
            return cellphone;
        }
        if (SensitiveDataUtil.isBlank(cellphone)) {
            return cellphone;
        }
        String tmp = cellphone.trim();
        if (cellphone.length() == 11) {
            return SensitiveDataUtil.customizeHide(tmp, 3, 2, 1);
        }
        int notHideNum = tmp.length() - 4;
        return SensitiveDataUtil.customizeHide(tmp, notHideNum / 2, notHideNum - notHideNum / 2, 1);
    }

    public static String emailHide(String email, boolean doValidate) {
        if (!SensitiveDataUtil.needHide()) {
            return email;
        }
        if (SensitiveDataUtil.isBlank(email)) {
            return email;
        }
        if (doValidate && !SensitiveDataUtil.isEmail(email)) {
            return SensitiveDataUtil.defaultHide(email);
        }
        String tmp = email.trim();
        int atPos = tmp.indexOf(64);
        int frontNum = atPos < 3 ? atPos : 3;
        return SensitiveDataUtil.customizeHide(tmp, frontNum, tmp.length() - atPos, 3);
    }

    public static String emailHide(String email) {
        return SensitiveDataUtil.emailHide(email, false);
    }

    public static String emailHideSMS(String email, boolean doValidate) {
        if (!SensitiveDataUtil.needHide()) {
            return email;
        }
        if (SensitiveDataUtil.isBlank(email)) {
            return email;
        }
        if (doValidate && !SensitiveDataUtil.isEmail(email)) {
            return SensitiveDataUtil.defaultHide(email);
        }
        StringBuilder result = new StringBuilder();
        String tmp = email.trim();
        int atPos = tmp.indexOf(64);
        int frontNum = atPos < 3 ? atPos : 3;
        result.append(tmp.substring(0, frontNum));
        result.append("*@");
        String backStr = tmp.substring(atPos + 1);
        int dotIndex = backStr.indexOf(46);
        if (dotIndex <= 7) {
            result.append(backStr.substring(0, dotIndex) + ".*");
        } else {
            result.append(backStr.substring(0, 7) + "*");
        }
        return result.toString();
    }

    public static String emailHideSMS(String email) {
        return SensitiveDataUtil.emailHideSMS(email, false);
    }

    public static String filterHide(String sourceStr, String tagBegin, String tagEnd, int sensitiveDataType) {
        if (!SensitiveDataUtil.needHide()) {
            return sourceStr;
        }
        if (SensitiveDataUtil.isBlank(sourceStr)) {
            return sourceStr;
        }
        StringBuilder tmp = new StringBuilder(sourceStr);
        StringBuilder target = new StringBuilder();
        int begin = tmp.indexOf(tagBegin);
        int end = tmp.indexOf(tagEnd);
        while (begin != -1 && end != -1) {
            target = target.append(tmp.toString().toCharArray(), 0, begin + tagBegin.length());
            String coverReplace = "";
            switch (sensitiveDataType) {
                case 0: {
                    coverReplace = SensitiveDataUtil.bankCardNoHide(tmp.substring(begin + tagBegin.length(), end));
                    break;
                }
                case 1: {
                    coverReplace = SensitiveDataUtil.idCardNoHide(tmp.substring(begin + tagBegin.length(), end));
                    break;
                }
                case 2: {
                    coverReplace = SensitiveDataUtil.phoneOrTelNoHide(tmp.substring(begin + tagBegin.length(), end));
                    break;
                }
                case 3: {
                    coverReplace = SensitiveDataUtil.emailHide(tmp.substring(begin + tagBegin.length(), end));
                    break;
                }
                default: {
                    coverReplace = SensitiveDataUtil.defaultHide(tmp.substring(begin + tagBegin.length(), end));
                }
            }
            target.append(coverReplace);
            target.append(tagEnd);
            tmp = new StringBuilder(tmp.substring(end + tagEnd.length()));
            begin = tmp.indexOf(tagBegin);
            end = tmp.indexOf(tagEnd);
        }
        target.append((CharSequence)tmp);
        return target.toString();
    }

    public static String taobaoNickHide(String sensitiveData) {
        if (!SensitiveDataUtil.needHide()) {
            return sensitiveData;
        }
        if (SensitiveDataUtil.isBlank(sensitiveData)) {
            return sensitiveData;
        }
        String tmp = sensitiveData.trim();
        return SensitiveDataUtil.customizeHide(tmp, 1, 1, 2);
    }

    public static String defaultHide(String sensitiveData) {
        if (!SensitiveDataUtil.needHide()) {
            return sensitiveData;
        }
        if (SensitiveDataUtil.isBlank(sensitiveData)) {
            return sensitiveData;
        }
        String tmp = sensitiveData.trim();
        int length = tmp.length();
        int headNum = (int)Math.ceil((double)(length * 1) / 3.0);
        int tailNum = (int)Math.floor((double)(length * 1) / 3.0);
        return SensitiveDataUtil.customizeHide(tmp, headNum, tailNum, length - headNum - tailNum);
    }

    public static String customizeHide(String sensitiveData, int frontCharNum, int tailCharNum, int hiddenCharNum) {
        if (SensitiveDataUtil.isBlank(sensitiveData)) {
            return sensitiveData;
        }
        String tmp = sensitiveData.trim();
        int length = tmp.length();
        if (frontCharNum < 0 || tailCharNum < 0 || hiddenCharNum < 0 || frontCharNum + tailCharNum > length) {
            return tmp;
        }
        int beginIndex = frontCharNum - 1;
        int endIndex = length - tailCharNum;
        StringBuilder result = new StringBuilder();
        if (beginIndex >= 0 && beginIndex < length) {
            result.append(tmp.substring(0, frontCharNum));
        }
        for (int i = 0; i < hiddenCharNum; ++i) {
            result.append('*');
        }
        if (endIndex >= 0 && endIndex < length) {
            result.append(tmp.substring(endIndex));
        }
        return result.toString();
    }

    private static boolean isBlank(String str) {
        int strLen;
        if (str == null || (strLen = str.length()) == 0) {
            return true;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean isIdCardNo(String idCardNo) {
        if (SensitiveDataUtil.isBlank(idCardNo)) {
            return false;
        }
        Matcher matcher = ID_CARD_PATTERN.matcher(idCardNo.trim());
        return matcher.matches();
    }

    private static boolean isBankCardNo(String bankCardNo) {
        if (SensitiveDataUtil.isBlank(bankCardNo)) {
            return false;
        }
        Matcher matcher = BANK_CARD_PATTERN.matcher(bankCardNo.trim());
        return matcher.matches();
    }

    private static boolean isPhoneOrTelNo(String phoneOrTelNo) {
        if (SensitiveDataUtil.isBlank(phoneOrTelNo)) {
            return false;
        }
        Matcher matcher = MAINLAND_PHONE_TEL_PATTERN.matcher(phoneOrTelNo.trim());
        return matcher.matches();
    }

    public static void setHideFlag(boolean hideFlag) {
        SensitiveDataUtil.hideFlag = hideFlag;
    }

    public static boolean needHide() {
        return hideFlag;
    }
}

