/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.store;

import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.common.MixAll;

public class DispatchRequest {
    private final String topic;
    private final int queueId;
    private final long commitLogOffset;
    private int msgSize;
    private final long tagsCode;
    private final long storeTimestamp;
    private final long consumeQueueOffset;
    private final String keys;
    private final boolean success;
    private final String uniqKey;
    private final int sysFlag;
    private final long preparedTransactionOffset;
    private final Map<String, String> propertiesMap;
    private byte[] bitMap;
    private int bufferSize = -1;
    private long msgBaseOffset = -1L;
    private short batchSize = 1;
    private long nextReputFromOffset = -1L;
    private String offsetId;

    public DispatchRequest(String topic, int queueId, long commitLogOffset, int msgSize, long tagsCode, long storeTimestamp, long consumeQueueOffset, String keys, String uniqKey, int sysFlag, long preparedTransactionOffset, Map<String, String> propertiesMap) {
        this.topic = topic;
        this.queueId = queueId;
        this.commitLogOffset = commitLogOffset;
        this.msgSize = msgSize;
        this.tagsCode = tagsCode;
        this.storeTimestamp = storeTimestamp;
        this.consumeQueueOffset = consumeQueueOffset;
        this.msgBaseOffset = consumeQueueOffset;
        this.keys = keys;
        this.uniqKey = uniqKey;
        this.sysFlag = sysFlag;
        this.preparedTransactionOffset = preparedTransactionOffset;
        this.success = true;
        this.propertiesMap = propertiesMap;
    }

    public DispatchRequest(String topic, int queueId, long consumeQueueOffset, long commitLogOffset, int size, long tagsCode) {
        this.topic = topic;
        this.queueId = queueId;
        this.commitLogOffset = commitLogOffset;
        this.msgSize = size;
        this.tagsCode = tagsCode;
        this.storeTimestamp = 0L;
        this.consumeQueueOffset = consumeQueueOffset;
        this.keys = "";
        this.uniqKey = null;
        this.sysFlag = 0;
        this.preparedTransactionOffset = 0L;
        this.success = false;
        this.propertiesMap = null;
    }

    public DispatchRequest(int size) {
        this.topic = "";
        this.queueId = 0;
        this.commitLogOffset = 0L;
        this.msgSize = size;
        this.tagsCode = 0L;
        this.storeTimestamp = 0L;
        this.consumeQueueOffset = 0L;
        this.keys = "";
        this.uniqKey = null;
        this.sysFlag = 0;
        this.preparedTransactionOffset = 0L;
        this.success = false;
        this.propertiesMap = null;
    }

    public DispatchRequest(int size, boolean success) {
        this.topic = "";
        this.queueId = 0;
        this.commitLogOffset = 0L;
        this.msgSize = size;
        this.tagsCode = 0L;
        this.storeTimestamp = 0L;
        this.consumeQueueOffset = 0L;
        this.keys = "";
        this.uniqKey = null;
        this.sysFlag = 0;
        this.preparedTransactionOffset = 0L;
        this.success = success;
        this.propertiesMap = null;
    }

    public String getTopic() {
        return this.topic;
    }

    public int getQueueId() {
        return this.queueId;
    }

    public long getCommitLogOffset() {
        return this.commitLogOffset;
    }

    public int getMsgSize() {
        return this.msgSize;
    }

    public long getStoreTimestamp() {
        return this.storeTimestamp;
    }

    public long getConsumeQueueOffset() {
        return this.consumeQueueOffset;
    }

    public String getKeys() {
        return this.keys;
    }

    public long getTagsCode() {
        return this.tagsCode;
    }

    public int getSysFlag() {
        return this.sysFlag;
    }

    public long getPreparedTransactionOffset() {
        return this.preparedTransactionOffset;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public String getUniqKey() {
        return this.uniqKey;
    }

    public Map<String, String> getPropertiesMap() {
        return this.propertiesMap;
    }

    public byte[] getBitMap() {
        return this.bitMap;
    }

    public void setBitMap(byte[] bitMap) {
        this.bitMap = bitMap;
    }

    public short getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(short batchSize) {
        this.batchSize = batchSize;
    }

    public void setMsgSize(int msgSize) {
        this.msgSize = msgSize;
    }

    public long getMsgBaseOffset() {
        return this.msgBaseOffset;
    }

    public void setMsgBaseOffset(long msgBaseOffset) {
        this.msgBaseOffset = msgBaseOffset;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public long getNextReputFromOffset() {
        return this.nextReputFromOffset;
    }

    public void setNextReputFromOffset(long nextReputFromOffset) {
        this.nextReputFromOffset = nextReputFromOffset;
    }

    public String getOffsetId() {
        return this.offsetId;
    }

    public void setOffsetId(String offsetId) {
        this.offsetId = offsetId;
    }

    public boolean containsLMQ() {
        if (!MixAll.topicAllowsLMQ((String)this.topic)) {
            return false;
        }
        if (null == this.propertiesMap || this.propertiesMap.isEmpty()) {
            return false;
        }
        String lmqNames = this.propertiesMap.get("INNER_MULTI_DISPATCH");
        String lmqOffsets = this.propertiesMap.get("INNER_MULTI_QUEUE_OFFSET");
        return !StringUtils.isBlank((CharSequence)lmqNames) && !StringUtils.isBlank((CharSequence)lmqOffsets);
    }

    public String toString() {
        return "DispatchRequest{topic='" + this.topic + '\'' + ", queueId=" + this.queueId + ", commitLogOffset=" + this.commitLogOffset + ", msgSize=" + this.msgSize + ", success=" + this.success + ", msgBaseOffset=" + this.msgBaseOffset + ", batchSize=" + this.batchSize + ", nextReputFromOffset=" + this.nextReputFromOffset + '}';
    }
}

