/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.antinstaller.renderer.text;

import java.io.PrintStream;

public class Pager {
    private char[] text;
    private int linesPerPage = 20;
    private int charsPerLine = 80;
    private int stringIndex = 0;

    public Pager(String text) {
        this.text = text.toCharArray();
    }

    public Pager() {
    }

    public String getText() {
        return new String(this.text);
    }

    public void setText(String text) {
        this.text = text.toCharArray();
    }

    public void rest(PrintStream out) {
        while (this.next(out)) {
        }
    }

    public boolean next(PrintStream out) {
        int lineChars = 0;
        int lastSpace = -1;
        char[] lineBuffer = new char[this.charsPerLine + 1];
        int lines = 0;
        while (lines < this.linesPerPage) {
            if (this.stringIndex >= this.text.length) {
                return false;
            }
            lineBuffer[lineChars] = this.text[this.stringIndex];
            if (this.text[this.stringIndex] == ' ') {
                lastSpace = lineChars;
            }
            if (this.text[this.stringIndex] == '\n') {
                String tmp = new String(lineBuffer, 0, lineChars + 1);
                out.print(tmp);
                ++lines;
                lineChars = 0;
                lastSpace = -1;
            } else if (lineChars == this.charsPerLine) {
                if (lastSpace != -1) {
                    out.println(new String(lineBuffer, 0, lastSpace));
                    this.stringIndex -= this.charsPerLine - lastSpace;
                } else {
                    out.println(new String(lineBuffer, 0, lineChars));
                }
                ++lines;
                lineChars = 0;
                lastSpace = -1;
            } else {
                ++lineChars;
            }
            ++this.stringIndex;
        }
        return true;
    }
}

