/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.antinstaller.renderer.swing;

import java.awt.Component;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import org.tp23.antinstaller.ValidationException;
import org.tp23.antinstaller.page.TextPage;
import org.tp23.antinstaller.renderer.swing.ClasspathHTMLEditorKit;
import org.tp23.antinstaller.renderer.swing.SwingPageRenderer;
import org.tp23.antinstaller.runtime.ConfigurationException;

public class TextPageRenderer
extends SwingPageRenderer {
    private JTextPane textPane = new JTextPane();
    private StringBuffer buffer = new StringBuffer();

    public boolean validateFields() throws ValidationException {
        return true;
    }

    public void instanceInit() throws Exception {
        String resource = ((TextPage)this.page).getHtmlResource();
        InputStream in = this.getClass().getResourceAsStream(resource);
        if (in == null) {
            throw new ConfigurationException("Html page resource is missing:" + resource);
        }
        BufferedReader br = new BufferedReader(new InputStreamReader(in));
        String read = null;
        while ((read = br.readLine()) != null) {
            this.buffer.append(read);
        }
        br.close();
        JLabel defaults = new JLabel();
        this.textPane.setBackground(defaults.getBackground());
        this.textPane.setEditable(false);
        this.textPane.setContentType("text/html");
        ClasspathHTMLEditorKit classpathKit = new ClasspathHTMLEditorKit();
        this.textPane.setEditorKit(classpathKit);
        this.textPane.setAutoscrolls(true);
        String rule = "body{font-family:" + defaults.getFont().getFamily() + ";font-size:" + defaults.getFont().getSize() + "}";
        classpathKit.getStyleSheet().addRule(rule);
        this.textPane.setBorder(BorderFactory.createEmptyBorder());
        JScrollPane scroller = new JScrollPane();
        scroller.setHorizontalScrollBarPolicy(30);
        scroller.setVerticalScrollBarPolicy(20);
        scroller.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4), BorderFactory.createEtchedBorder()));
        this.add((Component)scroller, "Center");
        scroller.getViewport().add(this.textPane);
        this.add((Component)scroller, "Center");
    }

    public void updateInputFields() {
    }

    public void updateDefaultValues() {
        String parsedHtml = this.ctx.getInstaller().getResultContainer().getDefaultValue(this.buffer.toString());
        this.textPane.setText(parsedHtml);
        this.textPane.setCaretPosition(0);
    }
}

