/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.antinstaller.renderer.swing;

import java.awt.Component;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.tp23.antinstaller.ValidationException;
import org.tp23.antinstaller.page.LicensePage;
import org.tp23.antinstaller.renderer.swing.SwingPageRenderer;
import org.tp23.antinstaller.runtime.ConfigurationException;

public class LicensePageRenderer
extends SwingPageRenderer {
    private static final ResourceBundle res = ResourceBundle.getBundle("org.tp23.antinstaller.renderer.Res");
    private JTextArea licenseTextArea = new JTextArea();
    private JScrollPane scrollPane = new JScrollPane();

    public boolean validateFields() throws ValidationException {
        return true;
    }

    public void instanceInit() throws Exception {
        String line;
        String resource = ((LicensePage)this.page).getResource();
        InputStream licensein = this.getClass().getResourceAsStream(resource);
        if (licensein == null) {
            throw new ConfigurationException("License resource '" + resource + "' is missing from installer");
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(licensein));
        StringBuffer sb = new StringBuffer();
        while ((line = reader.readLine()) != null) {
            sb.append(line);
            sb.append('\n');
        }
        this.licenseTextArea.setText(sb.toString());
        this.licenseTextArea.setTabSize(4);
        this.licenseTextArea.setAutoscrolls(true);
        this.licenseTextArea.setCaretPosition(0);
        this.licenseTextArea.setEditable(false);
        this.licenseTextArea.setLineWrap(true);
        this.licenseTextArea.setWrapStyleWord(true);
        this.licenseTextArea.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.scrollPane.getViewport().add(this.licenseTextArea);
        this.scrollPane.setVerticalScrollBarPolicy(22);
        this.scrollPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4), BorderFactory.createEtchedBorder()));
        this.add((Component)this.scrollPane, "Center");
        this.getNextButton().setText(res.getString("license.next.text"));
        this.getNextButton().setIcon(this.getImage("/resources/icons/ok.png"));
        this.getCancelButton().setText(res.getString("license.cancel.text"));
    }

    public void updateInputFields() {
    }

    public void updateDefaultValues() {
    }
}

