/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.antinstaller.renderer.swing;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.tp23.antinstaller.input.CheckboxInput;
import org.tp23.antinstaller.input.InputField;
import org.tp23.antinstaller.input.OutputField;
import org.tp23.antinstaller.renderer.swing.AICheckBox;
import org.tp23.antinstaller.renderer.swing.AILabel;
import org.tp23.antinstaller.renderer.swing.SizeConstants;
import org.tp23.antinstaller.renderer.swing.SwingOutputFieldRenderer;
import org.tp23.gui.GBCF;

public class CheckboxInputRenderer
extends SwingOutputFieldRenderer {
    protected CheckboxInput inputField;
    protected JLabel fieldLabel = new AILabel();
    protected AICheckBox checkBox = new AICheckBox();

    public void initComponent(JPanel parent) {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setOutputField(OutputField inputField) {
        this.inputField = (CheckboxInput)inputField;
    }

    public void updateInputField() {
        boolean selected = this.checkBox.isSelected();
        if (selected) {
            this.inputField.setValue("true");
        } else {
            this.inputField.setValue("false");
        }
    }

    public void updateDefaultValue() {
        if (!this.inputField.isEditted()) {
            String newDefault = this.inputField.getDefaultValue();
            this.checkBox.setSelected(InputField.isTrue(newDefault));
        }
    }

    private void jbInit() throws Exception {
        this.fieldLabel.setText(this.inputField.getDisplayText());
        this.checkBox.setSelected(OutputField.isTrue(this.inputField.getDefaultValue()));
        this.checkBox.setEnabled(!OutputField.isTrue(this.inputField.getForce()));
        this.checkBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CheckboxInputRenderer.this.updateInputField();
                CheckboxInputRenderer.this.inputField.setEditted(true);
            }
        });
    }

    public int addSelf(JPanel content, GBCF cf, int row, boolean overflow) {
        content.add((Component)this.fieldLabel, cf.getCell(row, 0));
        content.add((Component)this.checkBox, cf.getCell(row, 1));
        if (overflow) {
            this.checkBox.setOverflow(SizeConstants.OVERFLOW_FIELD_SIZE);
        }
        return ++row;
    }

    public void renderError() {
    }
}

