/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.antinstaller;

import java.io.File;
import java.io.FileOutputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.tp23.antinstaller.Installer;
import org.tp23.antinstaller.InstallerContext;
import org.tp23.antinstaller.PropertiesFileRenderer;
import org.tp23.antinstaller.input.ConditionalField;
import org.tp23.antinstaller.input.InputField;
import org.tp23.antinstaller.input.OutputField;
import org.tp23.antinstaller.input.SecretPropertyField;
import org.tp23.antinstaller.page.Page;

public class DefaultPropertiesFileRenderer
implements PropertiesFileRenderer {
    public void renderProperties(InstallerContext ctx, File baseDir) {
        block4: {
            Installer installer = ctx.getInstaller();
            Page[] completedPages = installer.getPages();
            Properties props = new Properties();
            props.put("basedir", baseDir.getAbsolutePath());
            props.setProperty("ant.install.config.version", ctx.getInstaller().getVersion());
            for (int i = 0; i < completedPages.length; ++i) {
                OutputField[] fields = completedPages[i].getOutputField();
                this.retrieveProperties(fields, props);
                List targets = completedPages[i].getTargets(ctx);
                if (targets.size() <= 0) continue;
                Iterator iterator = targets.iterator();
                StringBuffer targetProperty = new StringBuffer();
                while (iterator.hasNext()) {
                    String target = (String)iterator.next();
                    targetProperty.append(target).append(",");
                }
                props.put(completedPages[i].getName() + "-targets", targetProperty.toString());
            }
            try {
                File antInstallProperties = new File(baseDir.getAbsolutePath(), "ant.install.properties");
                FileOutputStream fos = new FileOutputStream(antInstallProperties);
                props.store(fos, "Ant Installer - AutoGenerated properties");
                fos.close();
            }
            catch (Throwable ex) {
                if (!ctx.getInstaller().isVerbose()) break block4;
                ctx.log(ex);
            }
        }
    }

    private void retrieveProperties(OutputField[] fields, Properties props) {
        for (int f = 0; f < fields.length; ++f) {
            if (fields[f] instanceof SecretPropertyField) continue;
            if (fields[f] instanceof ConditionalField) {
                ConditionalField confField = (ConditionalField)fields[f];
                this.retrieveProperties(confField.getFields(), props);
                continue;
            }
            if (!(fields[f] instanceof InputField)) continue;
            InputField field = (InputField)fields[f];
            String result = field.getInputResult();
            if (result == null) {
                result = "";
            }
            props.put(field.getProperty(), result);
        }
    }
}

