/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.security.mfa.util;

import java.util.Set;
import javax.portlet.PortletRequest;
import javax.security.auth.Subject;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.jetspeed.request.RequestContext;
import org.apache.jetspeed.security.PasswordCredential;
import org.apache.jetspeed.security.SecurityException;
import org.apache.jetspeed.security.User;
import org.apache.jetspeed.security.UserCredential;
import org.apache.jetspeed.security.UserManager;

/*
 * Exception performing whole class analysis ignored.
 */
public final class SecurityHelper {
    public static final String MFA_COOKIE = "jetspeed_mfa";
    public static final String MFA_VALID_COOKIE = "validated";

    public static UserCredential getCredential(UserManager um, User user) throws SecurityException {
        UserCredential credential = null;
        Subject subject = um.getSubject(user);
        Set<Object> credentials = subject.getPrivateCredentials();
        for (Object o : credentials) {
            if (!(o instanceof UserCredential)) continue;
            credential = (UserCredential)o;
            break;
        }
        return credential;
    }

    public static Cookie getMFACookie(PortletRequest pRequest, String username) {
        String MFAUserCookie = "jetspeed_mfa_" + username;
        HttpServletRequest request = SecurityHelper.getHttpServletRequest((PortletRequest)pRequest);
        Cookie auth = null;
        Cookie[] cookies = request.getCookies();
        for (int ix = 0; ix < cookies.length; ++ix) {
            if (!cookies[ix].getName().equals(MFAUserCookie)) continue;
            auth = cookies[ix];
            break;
        }
        return auth;
    }

    public static void addMFACookie(PortletRequest pRequest, String username, String value) {
        int FORTY_EIGHT_HOURS = 172800;
        SecurityHelper.addMFACookie((PortletRequest)pRequest, (String)username, (String)value, (int)172800);
    }

    public static void addMFACookie(PortletRequest pRequest, String username, String value, int lifetime) {
        String MFAUserCookie = "jetspeed_mfa_" + username;
        HttpServletResponse response = SecurityHelper.getHttpServletResponse((PortletRequest)pRequest);
        String path = SecurityHelper.getHttpServletRequest((PortletRequest)pRequest).getContextPath();
        Cookie auth = new Cookie(MFAUserCookie, value);
        auth.setPath(path);
        auth.setMaxAge(lifetime);
        response.addCookie(auth);
    }

    public static RequestContext getRequestContext(PortletRequest request) {
        return (RequestContext)request.getAttribute("org.apache.jetspeed.request.RequestContext");
    }

    public static HttpServletRequest getHttpServletRequest(PortletRequest pRequest) {
        return SecurityHelper.getRequestContext((PortletRequest)pRequest).getRequest();
    }

    public static HttpServletResponse getHttpServletResponse(PortletRequest pRequest) {
        return SecurityHelper.getRequestContext((PortletRequest)pRequest).getResponse();
    }

    public static boolean isEmpty(String s) {
        if (s == null) {
            return true;
        }
        return s.trim().length() == 0;
    }

    public static void updateCredentialInSession(RequestContext requestContext, PasswordCredential credential) {
        Subject subject = (Subject)requestContext.getSessionAttribute("org.apache.jetspeed.security.subject");
        for (Object o : subject.getPrivateCredentials()) {
            if (!(o instanceof UserCredential)) continue;
            ((UserCredential)o).synchronize((UserCredential)credential);
            break;
        }
    }
}

