/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.security.mfa.impl;

import java.io.File;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jetspeed.security.mfa.impl.RemovableResource;

public class ResourceRemovalCache
extends Thread {
    protected static final Log log = LogFactory.getLog(ResourceRemovalCache.class);
    private boolean stopping = false;
    private long scanRateSeconds = 60L;
    private long msTimeToLive = 120000L;
    private Map resources = new HashMap();

    public ResourceRemovalCache(long scanRateSeconds, long timeToLiveSeconds) {
        this.scanRateSeconds = scanRateSeconds;
        this.msTimeToLive = timeToLiveSeconds * 1000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStopping(boolean flag) {
        ResourceRemovalCache resourceRemovalCache = this;
        synchronized (resourceRemovalCache) {
            if (!this.stopping && flag) {
                this.stopping = flag;
                this.notifyAll();
            } else {
                flag = false;
            }
        }
        if (flag) {
            try {
                this.join(this.scanRateSeconds * 1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insert(RemovableResource r) {
        Map map = this.resources;
        synchronized (map) {
            this.resources.put(r.getKey(), r);
        }
    }

    public void shutdown() {
        this.setStopping(true);
        this.traverse(true);
    }

    @Override
    public synchronized void run() {
        this.traverse(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void traverse(boolean deleteAll) {
        boolean done = false;
        try {
            while (!done) {
                try {
                    if (deleteAll) {
                        done = true;
                    }
                    boolean count = false;
                    LinkedList<RemovableResource> deleted = new LinkedList<RemovableResource>();
                    for (Map.Entry e : this.resources.entrySet()) {
                        RemovableResource r = (RemovableResource)e.getValue();
                        long expired = System.currentTimeMillis() - r.getInsertedTime();
                        if (!deleteAll && expired <= this.msTimeToLive) continue;
                        deleted.add(r);
                    }
                    for (RemovableResource r : deleted) {
                        try {
                            File f = new File(r.getResource());
                            if (f.exists()) {
                                f.delete();
                            }
                            Map map = this.resources;
                            synchronized (map) {
                                this.resources.remove(r.getKey());
                            }
                        }
                        catch (Exception e1) {
                            log.error((Object)("Could not delete " + r.getResource()));
                        }
                    }
                }
                catch (Exception e) {
                    log.error((Object)"FileCache Scanner: Error in iteration...", (Throwable)e);
                }
                if (!done) {
                    this.wait(this.scanRateSeconds * 1000L);
                }
                if (!this.stopping) continue;
                this.stopping = false;
                done = true;
            }
        }
        catch (InterruptedException e) {
            log.error((Object)"FileCacheScanner: recieved interruption, exiting.", (Throwable)e);
        }
    }
}

