/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.portlets.wicket;

import org.apache.jetspeed.Jetspeed;
import org.apache.jetspeed.components.ComponentManager;
import org.apache.jetspeed.portlets.wicket.JetspeedContextAwareWicketFilter;
import org.apache.wicket.protocol.http.WicketFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JetspeedContextAwareWicketFilter
extends WicketFilter {
    final Logger logger = LoggerFactory.getLogger(JetspeedContextAwareWicketFilter.class);

    protected ClassLoader getClassLoader() {
        ClassLoader defaultClassLoader = super.getClassLoader();
        ClassLoader jetspeedContextAwareClassLoader = null;
        ComponentManager componentManager = Jetspeed.getComponentManager();
        if (componentManager != null) {
            ClassLoader jetspeedContextClassLoader = null;
            try {
                jetspeedContextClassLoader = componentManager.getClass().getClassLoader();
            }
            catch (SecurityException e) {
                this.logger.warn("Failed to access the portal context classloader: {}", (Object)e.toString());
                this.logger.warn("Without access portal context classloader, it might not available to use some admin portlets.");
            }
            if (jetspeedContextClassLoader != null) {
                jetspeedContextAwareClassLoader = new JetspeedContextAwareClassLoader(this, defaultClassLoader, jetspeedContextClassLoader);
            }
        }
        return jetspeedContextAwareClassLoader != null ? jetspeedContextAwareClassLoader : defaultClassLoader;
    }
}

