/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.portlets.sso;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.apache.http.Consts;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthCache;
import org.apache.http.client.CookieStore;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.jetspeed.portlets.sso.JetspeedSSOUtils;
import org.apache.jetspeed.portlets.sso.SSOPortletUtil;
import org.apache.jetspeed.security.JetspeedPrincipal;
import org.apache.jetspeed.security.PasswordCredential;
import org.apache.jetspeed.security.SecurityException;
import org.apache.jetspeed.security.User;
import org.apache.jetspeed.security.UserManager;
import org.apache.jetspeed.security.mfa.util.SecurityHelper;
import org.apache.jetspeed.sso.SSOException;
import org.apache.jetspeed.sso.SSOManager;
import org.apache.jetspeed.sso.SSOSite;
import org.apache.portals.applications.gems.browser.StatusMessage;
import org.apache.portals.applications.webcontent2.portlet.WebContentPortlet;
import org.apache.portals.messaging.PortletMessaging;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSOWebContentPortlet
extends WebContentPortlet {
    public static final String SSO_TYPE = "sso.type";
    public static final String SSO_TYPE_HTTP = "http";
    public static final String SSO_TYPE_BASIC = "basic";
    public static final String SSO_TYPE_BASIC_PREEMPTIVE = "basic.preemptive";
    public static final String SSO_TYPE_FORM = "form";
    public static final String SSO_TYPE_FORM_GET = "form.get";
    public static final String SSO_TYPE_FORM_POST = "form.post";
    public static final String SSO_TYPE_URL = "url";
    public static final String SSO_TYPE_URL_BASE64 = "url.base64";
    public static final String SSO_TYPE_CERTIFICATE = "certificate";
    public static final String SSO_TYPE_DEFAULT = "basic";
    public static final String NO_CREDENTIALS = "<p>No credentials configured for current user.</p>";
    public static final String[] SSO_TYPES = new String[]{"basic", "basic.preemptive", "form", "form.get", "form.post", "url", "url.base64", "certificate"};
    public static final String BASIC_AUTH_SCHEME_NAME = "basic";
    public static final String SSO_TYPE_URL_USERNAME_PARAM = "sso.url.Principal";
    public static final String SSO_TYPE_URL_PASSWORD_PARAM = "sso.url.Credential";
    public static final String SSO_TYPE_FORM_ACTION_URL = "sso.form.Action";
    public static final String SSO_TYPE_FORM_ACTION_ARGS = "sso.form.Args";
    public static final String SSO_TYPE_FORM_USERNAME_FIELD = "sso.form.Principal";
    public static final String SSO_TYPE_FORM_PASSWORD_FIELD = "sso.form.Credential";
    public static final String SSO_REQUEST_ATTRIBUTE_USERNAME = "sso.ra.username";
    public static final String SSO_REQUEST_ATTRIBUTE_PASSWORD = "sso.ra.password";
    public static final String SSO_EDIT_FIELD_PRINCIPAL = "ssoPrincipal";
    public static final String SSO_EDIT_FIELD_CREDENTIAL = "ssoCredential";
    public static final String FORM_AUTH_STATE = "ssowebcontent.form.authstate";
    protected static final Logger log = LoggerFactory.getLogger(SSOWebContentPortlet.class);
    protected PortletContext context;
    protected SSOManager sso;
    protected UserManager userManager;
    protected List<String> ssoTypesList;

    public void init(PortletConfig config) throws PortletException {
        super.init(config);
        this.context = this.getPortletContext();
        this.sso = (SSOManager)this.context.getAttribute("cps:SSO");
        if (this.sso == null) {
            throw new PortletException("Failed to find SSO Manager on portlet initialization");
        }
        this.userManager = (UserManager)this.context.getAttribute("cps:UserManager");
        if (null == this.userManager) {
            throw new PortletException("Failed to find the User Manager on portlet initialization");
        }
        this.ssoTypesList = new LinkedList();
        for (String s : SSO_TYPES) {
            this.ssoTypesList.add(s);
        }
    }

    protected JetspeedPrincipal getLocalPrincipal(String localUserName) {
        User localPrincipal = null;
        try {
            localPrincipal = this.userManager.getUser(localUserName);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return localPrincipal;
    }

    public void processAction(ActionRequest actionRequest, ActionResponse actionResponse) throws PortletException, IOException {
        String webContentParameter = actionRequest.getParameter("_AP_URL");
        String ssoPrincipalName = actionRequest.getParameter(SSO_EDIT_FIELD_PRINCIPAL);
        String ssoPrincipalPassword = actionRequest.getParameter(SSO_EDIT_FIELD_CREDENTIAL);
        super.processAction(actionRequest, actionResponse);
        if (webContentParameter == null || actionRequest.getPortletMode() == PortletMode.EDIT) {
            String siteUrl = actionRequest.getPreferences().getValue("SRC", "");
            SSOSite site = JetspeedSSOUtils.getBestSubjectSSOSiteByURL((SSOManager)this.sso, (String)siteUrl);
            try {
                if (!(SecurityHelper.isEmpty((String)siteUrl) || SecurityHelper.isEmpty((String)ssoPrincipalName) || SecurityHelper.isEmpty((String)ssoPrincipalPassword))) {
                    if (site == null) {
                        site = this.sso.newSite(siteUrl, siteUrl);
                        this.sso.addSite(site);
                        SSOPortletUtil.updateUser((SSOManager)this.sso, (PortletRequest)actionRequest, (SSOSite)site, (String)ssoPrincipalName, (String)ssoPrincipalPassword);
                    } else {
                        SSOPortletUtil.updateUser((SSOManager)this.sso, (PortletRequest)actionRequest, (SSOSite)site, (String)ssoPrincipalName, (String)ssoPrincipalPassword);
                    }
                }
            }
            catch (SSOException e) {
                String errorMessage = "Failed to add remote user for the portal principal, " + actionRequest.getUserPrincipal().getName() + ".";
                if (e.getCause() != null) {
                    errorMessage = errorMessage + " (" + e.getCause() + ")";
                }
                StatusMessage statusMessage = new StatusMessage(errorMessage, "portlet-msg-error");
                PortletMessaging.publish((PortletRequest)actionRequest, (String)"SSOWebContent", (String)"status", (Object)statusMessage);
                actionResponse.setPortletMode(PortletMode.EDIT);
            }
        }
    }

    public void doView(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        String siteName = request.getPreferences().getValue("SRC", null);
        SSOSite site = null;
        if (siteName != null) {
            site = JetspeedSSOUtils.getBestSubjectSSOSiteByURL((SSOManager)this.sso, (String)siteName);
        }
        if (site == null) {
            String warningMessage = this.getResourceBundle(request.getLocale()).getString("no.credentials");
            response.getWriter().print(warningMessage);
            return;
        }
        PasswordCredential pwc = SSOPortletUtil.getCredentialsForSite((SSOManager)this.sso, (String)siteName, (RenderRequest)request);
        if (pwc == null) {
            String warningMessage = this.getResourceBundle(request.getLocale()).getString("no.credentials");
            response.getWriter().print(warningMessage);
            return;
        }
        request.setAttribute(SSO_REQUEST_ATTRIBUTE_USERNAME, (Object)pwc.getUserName());
        request.setAttribute(SSO_REQUEST_ATTRIBUTE_PASSWORD, (Object)pwc.getPassword());
        StatusMessage msg = (StatusMessage)PortletMessaging.consume((PortletRequest)request, (String)"SSOWebContent", (String)"status");
        if (msg != null) {
            this.getContext(request).put("statusMsg", (Object)msg);
        }
        super.doView(request, response);
    }

    public void doEdit(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        String site = request.getPreferences().getValue("SRC", "");
        PasswordCredential pwc = SSOPortletUtil.getCredentialsForSite((SSOManager)this.sso, (String)site, (RenderRequest)request);
        if (pwc != null) {
            this.getContext(request).put(SSO_EDIT_FIELD_PRINCIPAL, (Object)pwc.getUserName());
            this.getContext(request).put(SSO_EDIT_FIELD_CREDENTIAL, (Object)pwc.getPassword());
        } else {
            this.getContext(request).put(SSO_EDIT_FIELD_PRINCIPAL, (Object)"");
            this.getContext(request).put(SSO_EDIT_FIELD_CREDENTIAL, (Object)"");
        }
        StatusMessage msg = (StatusMessage)PortletMessaging.consume((PortletRequest)request, (String)"SSOWebContent", (String)"status");
        if (msg != null) {
            this.getContext(request).put("statusMsg", (Object)msg);
        }
        this.getContext(request).put("ssoTypes", (Object)SSO_TYPES);
        this.getContext(request).put("ssoTypeSelected", (Object)request.getPreferences().getValue(SSO_TYPE, "basic"));
        super.doEdit(request, response);
    }

    protected HttpClientContext getHttpClientContext(PortletRequest request, HttpRequestBase httpRequest) {
        HttpClientContext httpClientContext = null;
        PortletPreferences prefs = request.getPreferences();
        String type = this.getSingleSignOnAuthType(prefs);
        if (SSO_TYPE_BASIC_PREEMPTIVE.equalsIgnoreCase(type)) {
            String ssoUserName = StringUtils.defaultString((String)((String)request.getAttribute(SSO_REQUEST_ATTRIBUTE_USERNAME)));
            String ssoPassword = StringUtils.defaultString((String)((String)request.getAttribute(SSO_REQUEST_ATTRIBUTE_PASSWORD)));
            httpClientContext = HttpClientContext.create();
            httpClientContext.setCredentialsProvider((CredentialsProvider)new BasicCredentialsProvider());
            httpClientContext.setAuthCache((AuthCache)new BasicAuthCache());
            URI targetURI = httpRequest.getURI();
            String targetScheme = targetURI.getScheme();
            String targetHost = targetURI.getHost();
            int targetPort = targetURI.getPort() > 0 ? targetURI.getPort() : ("https".equals(targetScheme) ? 443 : 80);
            HttpHost targetHttpHost = new HttpHost(targetHost, targetPort, targetScheme);
            httpClientContext.getAuthCache().put(targetHttpHost, (AuthScheme)new BasicScheme());
            httpClientContext.getCredentialsProvider().setCredentials(new AuthScope(targetHost, targetPort), (Credentials)new UsernamePasswordCredentials(ssoUserName, ssoPassword));
        }
        return httpClientContext;
    }

    protected byte[] doPreemptiveAuthentication(CloseableHttpClient client, CookieStore cookieStore, HttpRequestBase httpRequest, RenderRequest request, RenderResponse response) {
        byte[] result = super.doPreemptiveAuthentication(client, cookieStore, httpRequest, request, response);
        if (result != null) {
            return result;
        }
        PortletPreferences prefs = request.getPreferences();
        String type = this.getSingleSignOnAuthType(prefs);
        if (StringUtils.startsWith((String)type, (String)SSO_TYPE_FORM)) {
            try {
                HttpRequestBase httpFormRequest;
                Boolean formAuth = (Boolean)PortletMessaging.receive((PortletRequest)request, (String)FORM_AUTH_STATE);
                if (formAuth != null) {
                    return (byte[])(formAuth != false ? result : null);
                }
                PortletMessaging.publish((PortletRequest)request, (String)FORM_AUTH_STATE, (Object)Boolean.FALSE);
                String formAction = prefs.getValue(SSO_TYPE_FORM_ACTION_URL, "");
                if (StringUtils.isEmpty((String)formAction)) {
                    log.warn("sso.type specified as 'form', but no: sso.form.Action, action was specified - unable to preemptively authenticate by form.");
                    return null;
                }
                String userNameField = prefs.getValue(SSO_TYPE_FORM_USERNAME_FIELD, "");
                if (StringUtils.isEmpty((String)userNameField)) {
                    log.warn("sso.type specified as 'form', but no: sso.form.Principal, username field was specified - unable to preemptively authenticate by form.");
                    return null;
                }
                String passwordField = prefs.getValue(SSO_TYPE_FORM_PASSWORD_FIELD, "password");
                if (StringUtils.isEmpty((String)passwordField)) {
                    log.warn("sso.type specified as 'form', but no: sso.form.Credential, password field was specified - unable to preemptively authenticate by form.");
                    return null;
                }
                String userName = StringUtils.defaultString((String)((String)request.getAttribute(SSO_REQUEST_ATTRIBUTE_USERNAME)));
                String password = StringUtils.defaultString((String)((String)request.getAttribute(SSO_REQUEST_ATTRIBUTE_PASSWORD)));
                boolean isPost = true;
                isPost = StringUtils.contains((String)type, (char)'.') ? StringUtils.equalsIgnoreCase((String)StringUtils.substringAfter((String)type, (String)"."), (String)"POST") : StringUtils.equalsIgnoreCase((String)type, (String)"POST");
                String formMethod = isPost ? "POST" : "GET";
                HashMap<String, String[]> formParams = new HashMap<String, String[]>();
                formParams.put(userNameField, new String[]{userName});
                formParams.put(passwordField, new String[]{password});
                String formArgs = prefs.getValue(SSO_TYPE_FORM_ACTION_ARGS, "");
                if (StringUtils.isNotEmpty((String)formArgs)) {
                    String[] pairs;
                    for (String pair : pairs = StringUtils.split((String)formArgs, (String)";")) {
                        String paramName = StringUtils.substringBefore((String)pair, (String)"=");
                        String paramValue = StringUtils.substringAfter((String)pair, (String)"=");
                        if (!StringUtils.isNotEmpty((String)paramName)) continue;
                        formParams.put(paramName, new String[]{paramValue});
                    }
                }
                PortletMessaging.publish((PortletRequest)request, (String)FORM_AUTH_STATE, (Object)((result = this.doHttpWebContent(client, cookieStore, httpFormRequest = this.createHttpRequest(client, formMethod, formAction, null, formParams, request), 0, request, response, null)) != null ? 1 : 0));
                return result;
            }
            catch (Exception ex) {
                log.error("Form-based authentication failed", (Throwable)ex);
            }
        } else if (type.equalsIgnoreCase(SSO_TYPE_URL) || type.equalsIgnoreCase(SSO_TYPE_URL_BASE64)) {
            String userNameParam = prefs.getValue(SSO_TYPE_URL_USERNAME_PARAM, "");
            if (StringUtils.isEmpty((String)userNameParam)) {
                log.warn("sso.type specified as 'url', but no: sso.url.Principal, username parameter was specified - unable to preemptively authenticate by URL.");
                return null;
            }
            String passwordParam = prefs.getValue(SSO_TYPE_URL_PASSWORD_PARAM, "");
            if (StringUtils.isEmpty((String)passwordParam)) {
                log.warn("sso.type specified as 'url', but no: sso.url.Credential, password parameter was specified - unable to preemptively authenticate by URL.");
                return null;
            }
            String userName = StringUtils.defaultString((String)((String)request.getAttribute(SSO_REQUEST_ATTRIBUTE_USERNAME)));
            String password = StringUtils.defaultString((String)((String)request.getAttribute(SSO_REQUEST_ATTRIBUTE_PASSWORD)));
            if (SSO_TYPE_URL_BASE64.equalsIgnoreCase(type)) {
                Base64 encoder = new Base64();
                userName = new String(encoder.encode(userName.getBytes()));
                password = new String(encoder.encode(password.getBytes()));
            }
            if (httpRequest instanceof HttpPost) {
                ArrayList<BasicNameValuePair> formParams = new ArrayList<BasicNameValuePair>();
                formParams.add(new BasicNameValuePair(userNameParam, userName));
                formParams.add(new BasicNameValuePair(passwordParam, password));
                UrlEncodedFormEntity httpEntity = new UrlEncodedFormEntity(formParams, Consts.UTF_8);
                ((HttpPost)httpRequest).setEntity((HttpEntity)httpEntity);
            } else {
                try {
                    URIBuilder uriBuilder = new URIBuilder(httpRequest.getURI());
                    uriBuilder.addParameter(userNameParam, userName);
                    uriBuilder.addParameter(passwordParam, password);
                    httpRequest.setURI(uriBuilder.build());
                }
                catch (URISyntaxException e) {
                    log.error("URI syntax error.", (Throwable)e);
                }
            }
            return result;
        }
        return null;
    }

    protected String getSingleSignOnAuthType(PortletPreferences prefs) {
        String type = prefs.getValue(SSO_TYPE, "basic");
        if (SSO_TYPE_HTTP.equalsIgnoreCase(type)) {
            log.warn("sso.type: http, has been deprecated - use: basic, or: basic.preemptive");
            type = "basic";
        }
        return type;
    }
}

