/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.portlets.sso;

import java.io.IOException;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceURL;
import org.apache.commons.codec.binary.Base64;
import org.apache.jetspeed.portlets.sso.JetspeedSSOUtils;
import org.apache.jetspeed.portlets.sso.SSOPortletUtil;
import org.apache.jetspeed.portlets.sso.SSOWebContentPortlet;
import org.apache.jetspeed.security.PasswordCredential;
import org.apache.jetspeed.security.mfa.util.SecurityHelper;
import org.apache.jetspeed.sso.SSOException;
import org.apache.jetspeed.sso.SSOManager;
import org.apache.jetspeed.sso.SSOSite;
import org.apache.jetspeed.sso.SSOUser;
import org.apache.portals.applications.gems.browser.StatusMessage;
import org.apache.portals.applications.webcontent2.portlet.IFrameGenericPortlet;
import org.apache.portals.messaging.PortletMessaging;

public class SSOIFramePortlet
extends IFrameGenericPortlet {
    public static final String SSO_TYPE = "sso.type";
    public static final String SSO_TYPE_URL = "url";
    public static final String SSO_TYPE_URL_BASE64 = "url.base64";
    public static final String SSO_TYPE_HTTP = "http";
    public static final String SSO_TYPE_CERTIFICATE = "certificate";
    public static final String SSO_TYPE_FORM = "form";
    public static final String SSO_TYPE_FORM_GET = "form.get";
    public static final String SSO_TYPE_FORM_POST = "form.post";
    public static final String SSO_TYPE_URL_USERNAME = "sso.url.Principal";
    public static final String SSO_TYPE_URL_PASSWORD = "sso.url.Credential";
    public static final String SSO_TYPE_FORM_USERNAME = "sso.form.Principal";
    public static final String SSO_TYPE_FORM_PASSWORD = "sso.form.Credential";
    public static final String SSO_TYPE_FORM_ACTION = "sso.form.Action";
    public static final String SSO_TYPE_FORM_ARGS = "sso.form.Args";
    public static final String SSO_TYPE_FORM_AUTH_FLAG = SSOIFramePortlet.class.getName() + ".authFlag";
    public static final String SSO_REQUEST_ATTRIBUTE_USERNAME = "sso.ra.username";
    public static final String SSO_REQUEST_ATTRIBUTE_PASSWORD = "sso.ra.password";
    public static final String SSO_FORM_PRINCIPAL = "ssoPrincipal";
    public static final String SSO_FORM_CREDENTIAL = "ssoCredential";
    private PortletContext context;
    private SSOManager sso;

    public void init(PortletConfig config) throws PortletException {
        super.init(config);
        this.context = this.getPortletContext();
        this.sso = (SSOManager)this.context.getAttribute("cps:SSO");
        if (null == this.sso) {
            throw new PortletException("Failed to find SSO Provider on portlet initialization");
        }
    }

    public void doEdit(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        StatusMessage msg;
        String siteUrl = request.getPreferences().getValue("SRC", "");
        SSOSite site = JetspeedSSOUtils.getBestSubjectSSOSiteByURL((SSOManager)this.sso, (String)siteUrl);
        if (site != null) {
            try {
                SSOUser remoteUser = SSOPortletUtil.getRemoteUser((SSOManager)this.sso, (PortletRequest)request, (SSOSite)site);
                if (remoteUser != null) {
                    PasswordCredential pwc = this.sso.getCredentials(remoteUser);
                    this.getContext(request).put(SSO_FORM_PRINCIPAL, (Object)pwc.getUserName());
                    this.getContext(request).put(SSO_FORM_CREDENTIAL, (Object)pwc.getPassword());
                } else {
                    this.getContext(request).put(SSO_FORM_PRINCIPAL, (Object)"");
                    this.getContext(request).put(SSO_FORM_CREDENTIAL, (Object)"");
                }
            }
            catch (SSOException e) {
                if (e.getMessage().equals("The site has no Single Sign On credentails attached.")) {
                    this.getContext(request).put(SSO_FORM_PRINCIPAL, (Object)"");
                    this.getContext(request).put(SSO_FORM_CREDENTIAL, (Object)"");
                }
                SSOPortletUtil.publishStatusMessage((PortletRequest)request, (String)"SSOIFrame", (String)"status", (Throwable)e, (String)"Could not load Site info for user");
            }
        }
        if ((msg = (StatusMessage)PortletMessaging.consume((PortletRequest)request, (String)"SSOIFrame", (String)"status")) != null) {
            this.getContext(request).put("statusMsg", (Object)msg);
        }
        this.getContext(request).put("ssoTypes", (Object)SSOWebContentPortlet.SSO_TYPES);
        this.getContext(request).put("ssoTypeSelected", (Object)request.getPreferences().getValue(SSO_TYPE, "basic"));
        super.doEdit(request, response);
    }

    public void doView(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        String siteUrl = request.getPreferences().getValue("SRC", null);
        SSOSite site = null;
        if (siteUrl != null) {
            site = JetspeedSSOUtils.getBestSubjectSSOSiteByURL((SSOManager)this.sso, (String)siteUrl);
        }
        if (site == null) {
            String warningMessage = this.getResourceBundle(request.getLocale()).getString("no.credentials");
            response.getWriter().print(warningMessage);
            return;
        }
        try {
            SSOUser remoteUser = SSOPortletUtil.getRemoteUser((SSOManager)this.sso, (PortletRequest)request, (SSOSite)site);
            if (remoteUser == null) {
                String warningMessage = this.getResourceBundle(request.getLocale()).getString("no.credentials");
                response.getWriter().print(warningMessage);
                return;
            }
            PasswordCredential pwc = this.sso.getCredentials(remoteUser);
            request.setAttribute(SSO_REQUEST_ATTRIBUTE_USERNAME, (Object)pwc.getUserName());
            request.setAttribute(SSO_REQUEST_ATTRIBUTE_PASSWORD, (Object)pwc.getPassword());
        }
        catch (SSOException e) {
            if (e.getMessage().equals("The site has no Single Sign On credentails attached.")) {
                String warningMessage = this.getResourceBundle(request.getLocale()).getString("no.credentials");
                response.getWriter().print(warningMessage);
                return;
            }
            SSOPortletUtil.publishStatusMessage((PortletRequest)request, (String)"SSOIFrame", (String)"status", (Throwable)e, (String)"Could not load Site info for user");
        }
        StatusMessage msg = (StatusMessage)PortletMessaging.consume((PortletRequest)request, (String)"SSOIFrame", (String)"status");
        if (msg != null) {
            this.getContext(request).put("statusMsg", (Object)msg);
        }
        super.doView(request, response);
    }

    public void processAction(ActionRequest request, ActionResponse actionResponse) throws PortletException, IOException {
        super.processAction(request, actionResponse);
        String ssoPrincipal = request.getParameter(SSO_FORM_PRINCIPAL);
        String ssoCredential = request.getParameter(SSO_FORM_CREDENTIAL);
        if (ssoPrincipal == null || ssoCredential == null) {
            actionResponse.setPortletMode(PortletMode.EDIT);
        }
        String siteUrl = request.getPreferences().getValue("SRC", "");
        SSOSite site = JetspeedSSOUtils.getBestSubjectSSOSiteByURL((SSOManager)this.sso, (String)siteUrl);
        try {
            if (!(SecurityHelper.isEmpty((String)siteUrl) || SecurityHelper.isEmpty((String)ssoPrincipal) || SecurityHelper.isEmpty((String)ssoCredential))) {
                if (site == null) {
                    site = this.sso.newSite(siteUrl, siteUrl);
                    this.sso.addSite(site);
                    SSOPortletUtil.updateUser((SSOManager)this.sso, (PortletRequest)request, (SSOSite)site, (String)ssoPrincipal, (String)ssoCredential);
                } else {
                    SSOPortletUtil.updateUser((SSOManager)this.sso, (PortletRequest)request, (SSOSite)site, (String)ssoPrincipal, (String)ssoCredential);
                }
            }
        }
        catch (SSOException e) {
            String errorMessage = "Failed to add remote user for the portal principal, " + request.getUserPrincipal().getName() + ".";
            if (e.getCause() != null) {
                errorMessage = errorMessage + " (" + e.getCause() + ")";
            }
            StatusMessage statusMessage = new StatusMessage(errorMessage, "portlet-msg-error");
            PortletMessaging.publish((PortletRequest)request, (String)"SSOIFrame", (String)"status", (Object)statusMessage);
            actionResponse.setPortletMode(PortletMode.EDIT);
        }
    }

    public String getURLSource(RenderRequest request, RenderResponse response, PortletPreferences prefs) {
        String baseSource = super.getURLSource(request, response, prefs);
        String type = prefs.getValue(SSO_TYPE, SSO_TYPE_URL);
        if (type.equals(SSO_TYPE_URL) || type.equals(SSO_TYPE_URL_BASE64)) {
            String password;
            String userNameParam = prefs.getValue(SSO_TYPE_URL_USERNAME, "user");
            String passwordParam = prefs.getValue(SSO_TYPE_URL_PASSWORD, "password");
            StringBuffer source = new StringBuffer(baseSource);
            if (baseSource.indexOf("?") == -1) {
                source.append("?");
            } else {
                source.append("&");
            }
            source.append(userNameParam);
            source.append("=");
            String userName = (String)request.getAttribute(SSO_REQUEST_ATTRIBUTE_USERNAME);
            if (userName == null) {
                userName = "";
            }
            if ((password = (String)request.getAttribute(SSO_REQUEST_ATTRIBUTE_PASSWORD)) == null) {
                password = "";
            }
            if (type.equals(SSO_TYPE_URL_BASE64)) {
                Base64 encoder = new Base64();
                userName = new String(encoder.encode(userName.getBytes()));
                password = new String(encoder.encode(password.getBytes()));
            }
            source.append(userName);
            source.append("&");
            source.append(passwordParam);
            source.append("=");
            source.append(password);
            return response.encodeURL(source.toString());
        }
        if (type.equals(SSO_TYPE_FORM) || type.equals(SSO_TYPE_FORM_GET) || type.equals(SSO_TYPE_FORM_POST)) {
            PortletSession portletSession = request.getPortletSession(false);
            if (portletSession == null || portletSession.getAttribute(SSO_TYPE_FORM_AUTH_FLAG) == null) {
                ResourceURL ssoLoginUrl = response.createResourceURL();
                ssoLoginUrl.setResourceID("/WEB-INF/security/sso/sso-iframe-form-login.jsp");
                return ssoLoginUrl.toString();
            }
            return baseSource;
        }
        return baseSource;
    }
}

