/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.portlets.spaces;

import java.io.IOException;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.jetspeed.portlets.spaces.SpaceBean;
import org.apache.jetspeed.portlets.spaces.SpaceNavigator;
import org.apache.jetspeed.portlets.spaces.UserSpaceBeanList;
import org.apache.jetspeed.portlets.toolbox.ThemeBean;
import org.apache.jetspeed.request.RequestContext;
import org.apache.jetspeed.spaces.Space;
import org.apache.jetspeed.spaces.Spaces;
import org.apache.jetspeed.spaces.SpacesException;
import org.apache.portals.bridges.common.GenericServletPortlet;
import org.apache.portals.messaging.PortletMessaging;
import org.w3c.dom.Element;

public class SpacesList
extends GenericServletPortlet {
    private Spaces spacesService;
    protected String yuiScriptPath = "/javascript/yui/build/yui/yui-min.js";

    public void init(PortletConfig config) throws PortletException {
        super.init(config);
        PortletContext context = this.getPortletContext();
        this.spacesService = (Spaces)context.getAttribute("cps:SpacesService");
        if (this.spacesService == null) {
            throw new PortletException("Could not get instance of portal spaces service component");
        }
        String param = config.getInitParameter("yuiScriptPath");
        if (param != null) {
            this.yuiScriptPath = param;
        }
    }

    protected void doHeaders(RenderRequest request, RenderResponse response) {
        super.doHeaders(request, response);
        RequestContext rc = (RequestContext)request.getAttribute("org.apache.jetspeed.request.RequestContext");
        Element headElem = response.createElement("script");
        headElem.setAttribute("language", "javascript");
        String scriptPath = rc.getRequest().getContextPath() + this.yuiScriptPath;
        headElem.setAttribute("id", "header.yui.library.include");
        headElem.setAttribute("src", scriptPath);
        headElem.setAttribute("type", "text/javascript");
        response.addProperty("javax.portlet.markup.head.element", headElem);
    }

    public void doView(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        String userName = request.getUserPrincipal() != null ? request.getUserPrincipal().getName() : null;
        UserSpaceBeanList spaces = (UserSpaceBeanList)request.getPortletSession().getAttribute("spaces", 1);
        if (spaces != null && !StringUtils.equals((String)spaces.getUserName(), (String)userName)) {
            request.getPortletSession().removeAttribute("spaces", 1);
            spaces = null;
        }
        if (spaces == null) {
            spaces = SpaceNavigator.createSpaceBeanList((Spaces)this.spacesService, (String)userName, null);
            request.getPortletSession().setAttribute("spaces", (Object)spaces);
        }
        request.setAttribute("spaces", (Object)spaces);
        SpaceBean space = (SpaceBean)request.getPortletSession().getAttribute("space", 1);
        request.setAttribute("space", (Object)space);
        try {
            super.doView(request, response);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public void processAction(ActionRequest request, ActionResponse response) throws PortletException, IOException {
        String spaceName = request.getParameter("edit");
        if (spaceName != null) {
            PortletMessaging.publish((PortletRequest)request, (String)"SpaceList", (String)"spaceChange", (Object)spaceName);
            ThemeBean.clearThemesSession((PortletRequest)request);
        } else {
            spaceName = request.getParameter("delete");
            if (spaceName != null) {
                Space space = this.spacesService.lookupSpace(spaceName);
                if (space != null) {
                    try {
                        this.spacesService.deleteSpace(space);
                        request.getPortletSession().removeAttribute("spaces", 1);
                        PortletMessaging.cancel((PortletRequest)request, (String)"SpaceList", (String)"spaceChange");
                        PortletMessaging.cancel((PortletRequest)request, (String)"SpaceNavigator", (String)"spaceChange");
                        PortletMessaging.cancel((PortletRequest)request, (String)"PageNavigator", (String)"spaceChange");
                        request.getPortletSession().removeAttribute("spaces", 1);
                        request.getPortletSession().removeAttribute("space", 1);
                        ThemeBean.clearThemesSession((PortletRequest)request);
                    }
                    catch (SpacesException e) {
                        throw new PortletException((Throwable)e);
                    }
                }
            } else {
                String add = request.getParameter("addspace");
                if (add != null) {
                    PortletMessaging.cancel((PortletRequest)request, (String)"SpaceList", (String)"spaceChange");
                    ThemeBean.clearThemesSession((PortletRequest)request);
                }
            }
        }
    }
}

