/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.portlets.spaces;

import java.security.Principal;
import javax.portlet.PortletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.jetspeed.administration.PortalAdministration;
import org.apache.jetspeed.portlets.spaces.SpaceBean;

public class SpaceAdminUtils {
    public static final String SPACE_ADMIN_ROLES_PARAM_NAME = "spaceAdminRoles";

    private SpaceAdminUtils() {
    }

    public static boolean isUserSpaceOwner(SpaceBean spaceBean, PortletRequest request) {
        Principal principal = request.getUserPrincipal();
        return principal != null && principal.getName().equals(spaceBean.getOwner());
    }

    public static boolean isUserSpaceAdmin(SpaceBean spaceBean, PortalAdministration portalAdmin, PortletRequest request) {
        String spaceAdminRolesPref = request.getPreferences().getValue(SPACE_ADMIN_ROLES_PARAM_NAME, null);
        if (!StringUtils.isBlank((String)spaceAdminRolesPref)) {
            String[] spaceAdminRoles;
            for (String role : spaceAdminRoles = StringUtils.split((String)spaceAdminRolesPref, (String)", \t\r\n")) {
                if (!request.isUserInRole(role)) continue;
                return true;
            }
        }
        return portalAdmin.isAdminUser(request) || portalAdmin.isUserInAdminRole(request);
    }
}

