/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.portlets.site;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.jetspeed.exception.JetspeedException;
import org.apache.jetspeed.om.folder.Folder;
import org.apache.jetspeed.om.page.DynamicPage;
import org.apache.jetspeed.om.page.FragmentDefinition;
import org.apache.jetspeed.om.page.Link;
import org.apache.jetspeed.om.page.Page;
import org.apache.jetspeed.om.page.PageTemplate;
import org.apache.jetspeed.page.PageManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class PortalSiteManagerUtil {
    private static final Logger logger = LoggerFactory.getLogger(PortalSiteManagerUtil.class);
    private static String pathSeprator = System.getProperty("file.separator");
    private static String pageRoot = System.getProperty("java.io.tmpdir");

    private PortalSiteManagerUtil() {
    }

    public static String getDownloadLink(String objectName, String userName, String objectType) throws Exception {
        if ("/".equals(objectName)) {
            objectName = "";
        }
        String link = "";
        String basePath = System.getProperty("java.io.tmpdir");
        if (objectType.equalsIgnoreCase("folder")) {
            String target;
            String sourcePath = null;
            sourcePath = !StringUtils.isEmpty((String)objectName) ? PortalSiteManagerUtil.getUserFolder((String)userName, (boolean)false) + pathSeprator + objectName : PortalSiteManagerUtil.getUserFolder((String)userName, (boolean)false);
            boolean success = PortalSiteManagerUtil.zipObject((String)sourcePath, (String)(target = sourcePath + ".zip"));
            if (!success) {
                throw new Exception("Error Occurered in zipping the file");
            }
            link = target;
        } else {
            link = basePath + "/" + userName + "/" + objectName;
        }
        return link;
    }

    public static Folder importFolder(PageManager castorPageManager, Folder srcFolder, String userName, String destination) throws JetspeedException {
        return PortalSiteManagerUtil.importFolder((PageManager)castorPageManager, (Folder)srcFolder, (String)userName, (String)destination, (boolean)true);
    }

    public static Folder importFolder(PageManager castorPageManager, Folder srcFolder, String userName, String destination, boolean copyIds) throws JetspeedException {
        String newPath = "";
        Folder dstFolder = PortalSiteManagerUtil.lookupFolder((PageManager)castorPageManager, (String)srcFolder.getPath());
        dstFolder = castorPageManager.copyFolder(srcFolder, PortalSiteManagerUtil.getUserFolder((String)userName, (boolean)true) + destination);
        castorPageManager.updateFolder(dstFolder);
        for (Page srcPage : srcFolder.getPages()) {
            Page dstPage = PortalSiteManagerUtil.lookupPage((PageManager)castorPageManager, (String)srcPage.getPath());
            newPath = PortalSiteManagerUtil.getUserFolder((String)userName, (boolean)true) + destination + PortalSiteManagerUtil.getRealPath((String)srcPage.getPath());
            dstPage = castorPageManager.copyPage(srcPage, newPath, copyIds);
            castorPageManager.updatePage(dstPage);
        }
        for (PageTemplate srcPageTemplate : srcFolder.getPageTemplates()) {
            PageTemplate dstPageTemplate = PortalSiteManagerUtil.lookupPageTemplate((PageManager)castorPageManager, (String)srcPageTemplate.getPath());
            newPath = PortalSiteManagerUtil.getUserFolder((String)userName, (boolean)true) + destination + PortalSiteManagerUtil.getRealPath((String)srcPageTemplate.getPath());
            dstPageTemplate = castorPageManager.copyPageTemplate(srcPageTemplate, newPath, copyIds);
            castorPageManager.updatePageTemplate(dstPageTemplate);
        }
        for (DynamicPage srcDynamicPage : srcFolder.getDynamicPages()) {
            DynamicPage dstDynamicPage = PortalSiteManagerUtil.lookupDynamicPage((PageManager)castorPageManager, (String)srcDynamicPage.getPath());
            newPath = PortalSiteManagerUtil.getUserFolder((String)userName, (boolean)true) + destination + PortalSiteManagerUtil.getRealPath((String)srcDynamicPage.getPath());
            dstDynamicPage = castorPageManager.copyDynamicPage(srcDynamicPage, newPath, copyIds);
            castorPageManager.updateDynamicPage(dstDynamicPage);
        }
        for (FragmentDefinition srcFragmentDefinition : srcFolder.getFragmentDefinitions()) {
            FragmentDefinition dstFragmentDefinition = PortalSiteManagerUtil.lookupFragmentDefinition((PageManager)castorPageManager, (String)srcFragmentDefinition.getPath());
            newPath = PortalSiteManagerUtil.getUserFolder((String)userName, (boolean)true) + destination + PortalSiteManagerUtil.getRealPath((String)srcFragmentDefinition.getPath());
            dstFragmentDefinition = castorPageManager.copyFragmentDefinition(srcFragmentDefinition, newPath, copyIds);
            castorPageManager.updateFragmentDefinition(dstFragmentDefinition);
        }
        for (Link srcLink : srcFolder.getLinks()) {
            Link dstLink = PortalSiteManagerUtil.lookupLink((PageManager)castorPageManager, (String)srcLink.getPath());
            newPath = PortalSiteManagerUtil.getUserFolder((String)userName, (boolean)true) + destination + PortalSiteManagerUtil.getRealPath((String)srcLink.getPath());
            dstLink = castorPageManager.copyLink(srcLink, newPath);
            castorPageManager.updateLink(dstLink);
        }
        for (Folder folder : srcFolder.getFolders()) {
            newPath = destination + PortalSiteManagerUtil.getRealPath((String)folder.getPath());
            PortalSiteManagerUtil.importFolder((PageManager)castorPageManager, (Folder)folder, (String)userName, (String)newPath, (boolean)copyIds);
        }
        return dstFolder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zipFiles(File cpFile, String sourcePath, ZipOutputStream cpZipOutputStream) {
        if (cpFile.isDirectory()) {
            File[] fList = cpFile.listFiles();
            for (int i = 0; i < fList.length; ++i) {
                PortalSiteManagerUtil.zipFiles((File)fList[i], (String)sourcePath, (ZipOutputStream)cpZipOutputStream);
            }
        } else {
            FileInputStream cpFileInputStream = null;
            try {
                String strAbsPath = cpFile.getAbsolutePath();
                String strZipEntryName = strAbsPath.substring(sourcePath.length() + 1, strAbsPath.length());
                cpFileInputStream = new FileInputStream(cpFile);
                ZipEntry cpZipEntry = new ZipEntry(strZipEntryName);
                cpZipOutputStream.putNextEntry(cpZipEntry);
                IOUtils.copy((InputStream)cpFileInputStream, (OutputStream)cpZipOutputStream);
                cpZipOutputStream.closeEntry();
            }
            catch (Exception e) {
                logger.error("Unexpected exception during zipping files.", (Throwable)e);
            }
            finally {
                if (cpFileInputStream != null) {
                    try {
                        cpFileInputStream.close();
                    }
                    catch (Exception ce) {}
                }
            }
        }
    }

    public static String getUserFolder(String userName, boolean fullPath) {
        if (pathSeprator == null || pathSeprator.equals("")) {
            pathSeprator = "/";
        }
        if (fullPath) {
            return userName + pathSeprator;
        }
        return pageRoot + pathSeprator + userName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean zipObject(String sourcePath, String target) {
        FileOutputStream fos = null;
        ZipOutputStream cpZipOutputStream = null;
        try {
            File cpFile = new File(sourcePath);
            if (!cpFile.isDirectory()) {
                boolean bl = false;
                return bl;
            }
            fos = new FileOutputStream(target);
            cpZipOutputStream = new ZipOutputStream(fos);
            cpZipOutputStream.setLevel(9);
            PortalSiteManagerUtil.zipFiles((File)cpFile, (String)sourcePath, (ZipOutputStream)cpZipOutputStream);
            cpZipOutputStream.finish();
        }
        catch (Exception e) {
            logger.error("Unexpected exception during writing to zip output stream.", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (cpZipOutputStream != null) {
                try {
                    cpZipOutputStream.close();
                }
                catch (Exception ce) {}
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (Exception ce) {}
            }
        }
        return true;
    }

    private static Page lookupPage(PageManager castorPageManager, String path) {
        try {
            return castorPageManager.getPage(path);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static PageTemplate lookupPageTemplate(PageManager castorPageManager, String path) {
        try {
            return castorPageManager.getPageTemplate(path);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static DynamicPage lookupDynamicPage(PageManager castorPageManager, String path) {
        try {
            return castorPageManager.getDynamicPage(path);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static FragmentDefinition lookupFragmentDefinition(PageManager castorPageManager, String path) {
        try {
            return castorPageManager.getFragmentDefinition(path);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static Link lookupLink(PageManager castorPageManager, String path) {
        try {
            return castorPageManager.getLink(path);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static Folder lookupFolder(PageManager castorPageManager, String path) {
        try {
            return castorPageManager.getFolder(path);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static String getRealPath(String path) {
        int index = path.lastIndexOf("/");
        if (index > 0) {
            return path.substring(index);
        }
        return path;
    }

    public static String getParentPath(String path) {
        int index = path.lastIndexOf("/");
        if (index == 0) {
            return "/";
        }
        return path.substring(0, index);
    }
}

