/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.portlets.security.sso;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.jetspeed.portlets.security.SecurityUtil;
import org.apache.jetspeed.portlets.security.sso.SSODetails;
import org.apache.jetspeed.security.GroupManager;
import org.apache.jetspeed.security.JetspeedPrincipal;
import org.apache.jetspeed.security.SecurityException;
import org.apache.jetspeed.security.User;
import org.apache.jetspeed.security.UserManager;
import org.apache.jetspeed.sso.SSOException;
import org.apache.jetspeed.sso.SSOManager;
import org.apache.jetspeed.sso.SSOSite;
import org.apache.jetspeed.sso.SSOUser;
import org.apache.portals.applications.gems.browser.BrowserIterator;
import org.apache.portals.applications.gems.browser.BrowserPortlet;
import org.apache.portals.applications.gems.browser.DatabaseBrowserIterator;
import org.apache.portals.applications.gems.browser.StatusMessage;
import org.apache.portals.messaging.PortletMessaging;
import org.apache.velocity.context.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSODetails
extends BrowserPortlet {
    static final Logger logger = LoggerFactory.getLogger(SSODetails.class);
    private SSOManager sso;
    private UserManager userManager;
    private GroupManager groupManager;

    public void init(PortletConfig config) throws PortletException {
        super.init(config);
        this.sso = (SSOManager)this.getPortletContext().getAttribute("cps:SSO");
        if (null == this.sso) {
            throw new PortletException("Failed to find the SSO Manager on portlet initialization");
        }
        this.userManager = (UserManager)this.getPortletContext().getAttribute("cps:UserManager");
        if (null == this.userManager) {
            throw new PortletException("Failed to find the User Manager on portlet initialization");
        }
        this.groupManager = (GroupManager)this.getPortletContext().getAttribute("cps:GroupManager");
        if (null == this.groupManager) {
            throw new PortletException("Failed to find the Group Manager on portlet initialization");
        }
    }

    public void getRows(RenderRequest request, String sql, int windowSize) throws Exception {
        ArrayList<String> resultSetTitleList = new ArrayList<String>();
        ArrayList<String> resultSetTypeList = new ArrayList<String>();
        try {
            SSOSite site = null;
            ArrayList<RemoteAndLocalPrincipalPair> list = new ArrayList<RemoteAndLocalPrincipalPair>();
            resultSetTypeList.add(String.valueOf(12));
            resultSetTitleList.add("Principal");
            resultSetTypeList.add(String.valueOf(12));
            resultSetTitleList.add("Remote");
            String selectedSite = (String)PortletMessaging.receive((PortletRequest)request, (String)"site", (String)"selectedName");
            if (selectedSite != null) {
                site = this.sso.getSiteByName(selectedSite);
                Collection ssoUsers = this.sso.getUsersForSite(site);
                for (SSOUser user : ssoUsers) {
                    Collection principals = this.sso.getPortalPrincipals(user);
                    if (principals.size() != 1) continue;
                    list.add(new RemoteAndLocalPrincipalPair(user, (JetspeedPrincipal)principals.iterator().next()));
                }
            }
            DatabaseBrowserIterator iterator = new DatabaseBrowserIterator(list, resultSetTitleList, resultSetTypeList, windowSize);
            this.setBrowserIterator(request, (BrowserIterator)iterator);
        }
        catch (Exception e) {
            logger.error("Exception in getRows: ", (Throwable)e);
            throw e;
        }
    }

    public void doView(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        String change = (String)PortletMessaging.consume((PortletRequest)request, (String)"site", (String)"change");
        if (change != null) {
            this.clearBrowserIterator((PortletRequest)request);
        }
        Context context = this.getContext(request);
        String selectedSite = (String)PortletMessaging.receive((PortletRequest)request, (String)"site", (String)"selectedName");
        if (selectedSite != null) {
            int pos;
            context.put("currentSite", (Object)selectedSite);
            String title = this.getTitle(request);
            title = title != null ? ((pos = title.indexOf("-")) > 1 ? title.substring(0, pos) + "- " + selectedSite : title + " - " + selectedSite) : selectedSite;
            response.setTitle(title);
        }
        String userChooser = SecurityUtil.getAbsoluteUrl((RenderRequest)request, (String)"/Administrative/choosers/users.psml");
        String groupChooser = SecurityUtil.getAbsoluteUrl((RenderRequest)request, (String)"/Administrative/choosers/groups.psml");
        context.put("userChooser", (Object)userChooser);
        context.put("groupChooser", (Object)groupChooser);
        StatusMessage msg = (StatusMessage)PortletMessaging.consume((PortletRequest)request, (String)"SSODetails", (String)"status");
        if (msg != null) {
            this.getContext(request).put("statusMsg", (Object)msg);
        }
        super.doView(request, response);
    }

    protected JetspeedPrincipal getJetspeedPrincipal(String principalType, String principalName) throws SecurityException {
        User foundPrincipal = null;
        if (principalType.equals("user")) {
            foundPrincipal = this.userManager.getUser(principalName);
        } else if (principalType.equals("group")) {
            foundPrincipal = this.groupManager.getGroup(principalName);
        }
        return foundPrincipal;
    }

    public void processAction(ActionRequest request, ActionResponse response) throws PortletException, IOException {
        if (request.getPortletMode() == PortletMode.VIEW) {
            String refresh = request.getParameter("sso.refresh");
            String add = request.getParameter("sso.add");
            String deleteUser = request.getParameter("ssoDelete.user");
            String deleteGroup = request.getParameter("ssoDelete.group");
            if (refresh != null) {
                this.clearBrowserIterator((PortletRequest)request);
            } else if (StringUtils.isNotEmpty((String)deleteUser) || StringUtils.isNotEmpty((String)deleteGroup)) {
                String principalType = null;
                String principalName = null;
                if (StringUtils.isNotEmpty((String)deleteUser)) {
                    principalType = "user";
                    principalName = deleteUser;
                } else if (StringUtils.isNotEmpty((String)deleteGroup)) {
                    principalName = deleteGroup;
                    principalType = "group";
                }
                try {
                    String siteName = (String)PortletMessaging.receive((PortletRequest)request, (String)"site", (String)"selectedName");
                    SSOSite site = this.sso.getSiteByName(siteName);
                    if (site != null) {
                        Collection ssoUsers;
                        JetspeedPrincipal principal = this.getJetspeedPrincipal(principalType, principalName);
                        if (principal != null && (ssoUsers = this.sso.getRemoteUsers(site, principal)) != null && ssoUsers.size() == 1) {
                            this.sso.removeUser((SSOUser)ssoUsers.iterator().next());
                        }
                        this.clearBrowserIterator((PortletRequest)request);
                    }
                }
                catch (SSOException e) {
                    this.publishStatusMessage((PortletRequest)request, "SSODetails", "status", (Throwable)e, "Could not remove credentials");
                }
                catch (SecurityException e) {
                    this.publishStatusMessage((PortletRequest)request, "SSODetails", "status", (Throwable)e, "Could not remove credentials");
                }
            } else if (add != null) {
                String principalType = request.getParameter("principal.type");
                String portalPrincipal = request.getParameter("portal.principal");
                String remotePrincipal = request.getParameter("remote.principal");
                String remoteCredential = request.getParameter("remote.credential");
                if (principalType == null || principalType.length() == 0) {
                    principalType = "user";
                }
                if (!(StringUtils.isEmpty((String)remotePrincipal) || StringUtils.isEmpty((String)remotePrincipal) || StringUtils.isEmpty((String)remoteCredential))) {
                    try {
                        String siteName = (String)PortletMessaging.receive((PortletRequest)request, (String)"site", (String)"selectedName");
                        SSOSite site = this.sso.getSiteByName(siteName);
                        JetspeedPrincipal localPrincipal = this.getJetspeedPrincipal(principalType, portalPrincipal);
                        if (site != null && localPrincipal != null) {
                            if (this.sso.getRemoteUsers(site, localPrincipal).size() > 0) {
                                try {
                                    PortletMessaging.publish((PortletRequest)request, (String)"SSODetails", (String)"status", (Object)new StatusMessage("Could not add remote user: portal principal " + localPrincipal.getName() + " is already associated with a remote user for this site!", "portlet-msg-error"));
                                }
                                catch (Exception e) {
                                    logger.error("Failed to publish message: {}", (Throwable)e);
                                }
                            } else {
                                this.sso.addUser(site, localPrincipal, remotePrincipal, remoteCredential);
                                this.clearBrowserIterator((PortletRequest)request);
                            }
                        }
                    }
                    catch (SSOException e) {
                        this.publishStatusMessage((PortletRequest)request, "SSODetails", "status", (Throwable)e, "Could not add credentials");
                    }
                    catch (SecurityException se) {
                        this.publishStatusMessage((PortletRequest)request, "SSODetails", "status", (Throwable)se, "Could not add credentials");
                    }
                }
            }
        }
        super.processAction(request, response);
    }
}

