/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.portlets.rpad.simple;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import org.apache.jetspeed.portlets.rpad.PortletApplication;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class SimpleConfigHandler
extends DefaultHandler {
    private List<PortletApplication> portletApplications = new ArrayList();
    private PortletApplication portletApplication;
    private List qNameList = new ArrayList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) {
        if (!"repository".equals(qName) && "portlet".equals(qName)) {
            String version;
            String groupId;
            this.portletApplication = new PortletApplication();
            String artifactId = attributes.getValue("id");
            if (artifactId != null) {
                this.portletApplication.setArtifactId(artifactId);
            }
            if ((groupId = attributes.getValue("group")) != null) {
                this.portletApplication.setGroupId(groupId);
            }
            if ((version = attributes.getValue("version")) != null) {
                this.portletApplication.setVersion(version);
            }
        }
        List list = this.qNameList;
        synchronized (list) {
            this.qNameList.add(qName);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        Locale l;
        if (this.qNameList.size() < 1) {
            return;
        }
        String value = new String(ch, start, length);
        String qName = (String)this.qNameList.get(this.qNameList.size() - 1);
        String parentQName = this.qNameList.size() - 2 >= 0 ? (String)this.qNameList.get(this.qNameList.size() - 2) : "";
        if ("portletSpecVersion".equals(qName)) {
            this.portletApplication.setPortletSpecVersion(value);
        } else if ("packaging".equals(qName)) {
            this.portletApplication.setPackaging(value);
        } else if ("name".equals(qName)) {
            if ("publisher".equals(parentQName)) {
                this.portletApplication.setPublisherName(value);
            } else if ("license".equals(parentQName)) {
                this.portletApplication.setLicenseName(value);
            } else {
                this.portletApplication.setName(value);
            }
        } else if ("description".equals(qName)) {
            this.portletApplication.setDescription(value);
        } else if ("tag".equals(qName)) {
            this.portletApplication.addTag(value);
        } else if ("url".equals(qName)) {
            if ("publisher".equals(parentQName)) {
                this.portletApplication.setPublisherUrl(value);
            } else if ("license".equals(parentQName)) {
                this.portletApplication.setLicenseUrl(value);
            }
        } else if ("binaryURL".equals(qName)) {
            this.portletApplication.setBinaryUrl(value);
        } else if ("sourceURL".equals(qName)) {
            this.portletApplication.setSourceUrl(value);
        } else if ("imageURL".equals(qName)) {
            this.portletApplication.setImageUrl(value);
        } else if ("compiledJDKVersion".equals(qName)) {
            this.portletApplication.setCompiledJDKVersion(value);
        } else if ("locale".equals(qName) && (l = this.getLocaleFromString(value)) != null) {
            this.portletApplication.addSupportedLocale(l);
        }
    }

    private Locale getLocaleFromString(String localeString) {
        StringTokenizer st = new StringTokenizer(localeString, "_-");
        String[] buf = new String[3];
        int count = 0;
        while (st.hasMoreTokens()) {
            buf[count] = st.nextToken();
            ++count;
        }
        if (count > 2) {
            return new Locale(buf[0], buf[1], buf[2]);
        }
        if (count > 1) {
            return new Locale(buf[0], buf[1]);
        }
        if (count > 0) {
            return new Locale(buf[0]);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void endElement(String uri, String localName, String qName) {
        if ("portlet".equals(qName)) {
            this.portletApplications.add(this.portletApplication);
            this.portletApplication = null;
        }
        List list = this.qNameList;
        synchronized (list) {
            if (this.qNameList.size() < 1) {
                throw new IllegalStateException("The stacked QName is 0.");
            }
            String stackedQName = (String)this.qNameList.remove(this.qNameList.size() - 1);
            if (!qName.equals(stackedQName)) {
                throw new IllegalStateException("The expected QName is " + stackedQName + ". But the current value is " + qName);
            }
        }
    }

    public List<PortletApplication> getPortletApplications() {
        return this.portletApplications;
    }

    public void setPortletApplications(List<PortletApplication> portletApplications) {
        this.portletApplications = portletApplications;
    }
}

