/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.portlets.registration;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.WindowState;
import org.apache.jetspeed.JetspeedActions;
import org.apache.jetspeed.administration.AdministrationEmailException;
import org.apache.jetspeed.administration.PortalAdministration;
import org.apache.jetspeed.locator.JetspeedTemplateLocator;
import org.apache.jetspeed.locator.LocatorDescriptor;
import org.apache.jetspeed.locator.TemplateDescriptor;
import org.apache.jetspeed.locator.TemplateLocatorException;
import org.apache.jetspeed.portlets.registration.ForgottenPasswordPortlet;
import org.apache.jetspeed.request.RequestContext;
import org.apache.jetspeed.security.SecurityException;
import org.apache.jetspeed.security.User;
import org.apache.jetspeed.security.UserManager;
import org.apache.portals.bridges.util.PreferencesHelper;
import org.apache.portals.bridges.velocity.AbstractVelocityMessagingPortlet;
import org.apache.portals.gems.util.ValidationHelper;
import org.apache.velocity.context.Context;

public class UserRegistrationPortlet
extends AbstractVelocityMessagingPortlet {
    private PortalAdministration admin;
    private UserManager userManager;
    private static final String USER_ATTRIBUTE_EMAIL = "user.business-info.online.email";
    private static final String MSG_MESSAGE = "MSG";
    private static final String MSG_USERINFO = "user";
    private static final String MSG_REGED_USER_MSG = "registeredUserMsg";
    private static final String IP_ROLES = "roles";
    private static final String IP_GROUPS = "groups";
    private static final String IP_TEMPLATE_LOCATION = "emailTemplateLocation";
    private static final String IP_TEMPLATE_NAME = "emailTemplateName";
    private static final String IP_RULES_NAMES = "rulesNames";
    private static final String IP_RULES_VALUES = "rulesValues";
    private static final String IP_REDIRECT_PATH = "redirectPath";
    private static final String IP_RETURN_URL = "returnURL";
    private static final String IP_OPTION_EMAILS_SYSTEM_UNIQUE = "Option_Emails_System_Unique";
    private static final String IP_OPTION_GENERATE_PASSWORDS = "Option_Generate_Passwords";
    private static final String IP_OPTION_USE_EMAIL_AS_USERNAME = "Option_Use_Email_As_Username";
    private static final String CTX_RETURN_URL = "returnURL";
    private static final String CTX_MESSAGE = "MSG";
    private static final String CTX_USERINFO = "user";
    private static final String CTX_FIELDS = "fieldsInOrder";
    private static final String CTX_OPTIONALS = "optionalMap";
    private static final String CTX_REGED_USER_MSG = "registeredUserMsg";
    private static final String CTX_OPTION_GENERATE_PASSWORDS = "CTX_Option_Generate_Passwords";
    private static final String CTX_OPTION_USE_EMAIL_AS_USERNAME = "CTX_Option_Use_Email_As_Username";
    private static final String RB_EMAIL_SUBJECT = "email.subject.registration";
    private static final String PATH_SEPARATOR = "/";
    private String templateLocation;
    private String templateName;
    private JetspeedTemplateLocator templateLocator;
    private String emailSubject = null;
    private String redirectPath;
    private String returnUrlPath;
    private List<String> roles;
    private List<String> groups;
    private Map<String, String> rules;
    private boolean optionForceGeneratedPasswords = false;
    private boolean optionForceEmailAsUsername = true;
    private boolean optionForceEmailsToBeSystemUnique = true;
    private static final Boolean required = new Boolean(true);
    private static final Boolean optional = new Boolean(false);
    private static final Integer IS_STRING = new Integer(1);
    private static final Integer IS_EMAIL = new Integer(2);
    private static final Integer IS_PHONE = new Integer(3);
    private static final Integer IS_URL = new Integer(4);
    private static final Integer IS_BDATE = new Integer(5);
    protected static Object[][] formKeys = new Object[][]{{"user.business-info.online.email", required, new Integer(80), IS_EMAIL}, {"user.name", required, new Integer(80), IS_STRING}, {"password", required, new Integer(80), IS_STRING}, {"verifyPassword", required, new Integer(80), IS_STRING}, {"user.department", optional, new Integer(80), IS_STRING}, {"user.name.given", optional, new Integer(30), IS_STRING}, {"user.name.family", optional, new Integer(30), IS_STRING}, {"user.business-info.postal.name", optional, new Integer(80), IS_STRING}, {"user.business-info.postal.street", optional, new Integer(80), IS_STRING}, {"user.business-info.postal.city", optional, new Integer(80), IS_STRING}, {"user.business-info.postal.stateprov", optional, new Integer(80), IS_STRING}, {"user.business-info.postal.postalcode", optional, new Integer(80), IS_STRING}, {"user.business-info.postal.country", optional, new Integer(80), IS_STRING}};

    public void init(PortletConfig config) throws PortletException {
        super.init(config);
        this.admin = (PortalAdministration)this.getPortletContext().getAttribute("cps:PortalAdministration");
        if (null == this.admin) {
            throw new PortletException("Failed to find the Portal Administration on portlet initialization");
        }
        this.userManager = (UserManager)this.getPortletContext().getAttribute("cps:UserManager");
        if (null == this.userManager) {
            throw new PortletException("Failed to find the User Manager on portlet initialization");
        }
        this.roles = this.getInitParameterList(config, IP_ROLES);
        this.groups = this.getInitParameterList(config, IP_GROUPS);
        List names = this.getInitParameterList(config, IP_RULES_NAMES);
        List values = this.getInitParameterList(config, IP_RULES_VALUES);
        this.rules = new HashMap();
        for (int ix = 0; ix < (names.size() < values.size() ? names.size() : values.size()); ++ix) {
            this.rules.put(names.get(ix), values.get(ix));
        }
        this.templateLocation = config.getInitParameter(IP_TEMPLATE_LOCATION);
        if (this.templateLocation == null) {
            this.templateLocation = "/WEB-INF/view/userreg/";
        }
        this.templateLocation = this.getPortletContext().getRealPath(this.templateLocation);
        this.templateName = config.getInitParameter(IP_TEMPLATE_NAME);
        if (this.templateName == null) {
            this.templateName = "userRegistrationEmail.vm";
        }
        ArrayList<String> roots = new ArrayList<String>(1);
        roots.add(this.templateLocation);
        try {
            this.templateLocator = new JetspeedTemplateLocator(roots, "email", this.getPortletContext().getRealPath(PATH_SEPARATOR));
            this.templateLocator.start();
        }
        catch (FileNotFoundException e) {
            throw new PortletException("Could not start the template locator.", (Throwable)e);
        }
        this.optionForceEmailsToBeSystemUnique = Boolean.valueOf(config.getInitParameter(IP_OPTION_EMAILS_SYSTEM_UNIQUE));
        this.optionForceGeneratedPasswords = Boolean.valueOf(config.getInitParameter(IP_OPTION_GENERATE_PASSWORDS));
        this.optionForceEmailAsUsername = Boolean.valueOf(config.getInitParameter(IP_OPTION_USE_EMAIL_AS_USERNAME));
        if (this.optionForceEmailAsUsername) {
            this.optionForceEmailsToBeSystemUnique = true;
        }
        this.returnUrlPath = config.getInitParameter("returnURL");
        this.redirectPath = config.getInitParameter(IP_REDIRECT_PATH);
    }

    public void doEdit(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        response.setContentType("text/html");
        this.doPreferencesEdit(request, response);
    }

    protected void doDispatch(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        if (!request.getWindowState().equals((Object)WindowState.MINIMIZED)) {
            PortletMode curMode = request.getPortletMode();
            if (JetspeedActions.EDIT_DEFAULTS_MODE.equals((Object)curMode)) {
                this.doEdit(request, response);
            } else {
                super.doDispatch(request, response);
            }
        }
    }

    public void doView(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        response.setContentType("text/html");
        Context context = this.getContext(request);
        Object userinfoObject = this.receiveRenderMessage((PortletRequest)request, "user");
        context.put("user", userinfoObject);
        context.put(CTX_FIELDS, (Object)this.getListOfNonSpecialFormKeys());
        context.put(CTX_OPTIONALS, (Object)this.getOptionalMap());
        context.put("MSG", this.consumeRenderMessage((PortletRequest)request, "MSG"));
        String guid = request.getParameter("newUserGUID");
        if (guid != null) {
            ResourceBundle resource = this.getPortletConfig().getResourceBundle(request.getLocale());
            context.put("registeredUserMsg", (Object)resource.getString("success.login_above"));
        } else {
            context.put("registeredUserMsg", this.consumeRenderMessage((PortletRequest)request, "registeredUserMsg"));
        }
        if (this.optionForceEmailAsUsername) {
            context.put(CTX_OPTION_USE_EMAIL_AS_USERNAME, (Object)"TRUE");
        }
        if (this.optionForceGeneratedPasswords) {
            context.put(CTX_OPTION_GENERATE_PASSWORDS, (Object)"TRUE");
        }
        super.doView(request, response);
    }

    protected List<String> getListOfNonSpecialFormKeys() {
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < formKeys.length; ++i) {
            String key = (String)formKeys[i][0];
            if (key.equals("user.name") || key.equals(USER_ATTRIBUTE_EMAIL) || key.equals("password") || key.equals("verifyPassword")) continue;
            list.add(key);
        }
        return list;
    }

    protected Map getOptionalMap() {
        HashMap<Object, String> m = new HashMap<Object, String>();
        for (int i = 0; i < formKeys.length; ++i) {
            boolean isRequired = (Boolean)formKeys[i][1];
            if (isRequired) continue;
            m.put(formKeys[i][0], "");
        }
        return m;
    }

    protected boolean validateFormValue(String value, Integer length, Integer validationType) {
        return !(validationType.equals(IS_STRING) ? !ValidationHelper.isAny((String)value, (boolean)true, (int)length) : (validationType.equals(IS_EMAIL) ? !ValidationHelper.isEmailAddress((String)value, (boolean)true, (int)length) : (validationType.equals(IS_PHONE) ? !ValidationHelper.isPhoneNumber((String)value, (boolean)true, (int)length) : (validationType.equals(IS_URL) ? !ValidationHelper.isURL((String)value, (boolean)true, (int)length) : (validationType.equals(IS_BDATE) ? !ValidationHelper.isValidDatetime((String)value) : !ValidationHelper.isAny((String)value, (boolean)true, (int)length))))));
    }

    protected String convertIfNeed(String key, String value) {
        if ("user.bdate".equals(key)) {
            Date d = ValidationHelper.parseDate((String)value);
            long timeInmS = d.getTime();
            return "" + timeInmS;
        }
        return value;
    }

    public void processAction(ActionRequest actionRequest, ActionResponse actionResponse) throws PortletException, IOException {
        LinkedList<String> errors = new LinkedList<String>();
        HashMap<String, String> userAttributes = new HashMap<String, String>();
        HashMap<String, String> userInfo = new HashMap<String, String>();
        ResourceBundle resource = this.getPortletConfig().getResourceBundle(actionRequest.getLocale());
        PortletMode curMode = actionRequest.getPortletMode();
        if (curMode == PortletMode.EDIT || curMode.equals((Object)JetspeedActions.EDIT_DEFAULTS_MODE)) {
            PortletPreferences prefs = actionRequest.getPreferences();
            PreferencesHelper.requestParamsToPreferences((ActionRequest)actionRequest);
            prefs.store();
            actionResponse.setPortletMode(PortletMode.VIEW);
            return;
        }
        try {
            for (int i = 0; i < formKeys.length; ++i) {
                try {
                    String key = (String)formKeys[i][0];
                    Boolean isRequired = (Boolean)formKeys[i][1];
                    String value = actionRequest.getParameter(key);
                    if (value != null && value.length() > 0) {
                        userInfo.put(key, value);
                        if (!this.validateFormValue(value, (Integer)formKeys[i][2], (Integer)formKeys[i][3])) {
                            errors.add(resource.getString("error.invalid-format." + key));
                        }
                        if (!key.startsWith("user.")) continue;
                        value = this.convertIfNeed(key, value);
                        userAttributes.put(key, value);
                        continue;
                    }
                    if (isRequired.booleanValue()) {
                        if (this.optionForceEmailAsUsername && key.equals("user.name")) {
                            value = this.convertIfNeed(key, value);
                            userAttributes.put(key, value);
                            continue;
                        }
                        errors.add(resource.getString("error.lacking." + key));
                    }
                    userInfo.put(key, "");
                    continue;
                }
                catch (MissingResourceException mre) {
                    errors.add(resource.getString("error.failed_to_add") + mre.toString());
                }
            }
            this.publishRenderMessage((PortletRequest)actionRequest, "user", userInfo);
            if (this.optionForceEmailAsUsername) {
                if (!ValidationHelper.isEmailAddress((String)((String)userInfo.get(USER_ATTRIBUTE_EMAIL)), (boolean)true, (int)80)) {
                    errors.add(resource.getString("error.invalid-format.user.business-info.online.email"));
                }
            } else if (!ValidationHelper.isAny((String)((String)userInfo.get("user.name")), (boolean)true, (int)80)) {
                errors.add(resource.getString("error.lacking.user.name"));
            }
            if (!this.optionForceGeneratedPasswords && !ValidationHelper.isAny((String)((String)userInfo.get("password")), (boolean)true, (int)25)) {
                errors.add(resource.getString("error.lacking.password"));
            }
            if (this.optionForceEmailAsUsername) {
                userInfo.put("user.name", (String)userInfo.get(USER_ATTRIBUTE_EMAIL));
            }
            boolean userIdExistsFlag = true;
            try {
                this.userManager.getUser((String)userInfo.get("user.name"));
            }
            catch (SecurityException e) {
                userIdExistsFlag = false;
            }
            if (userIdExistsFlag) {
                errors.add(resource.getString("error.userid_already_exists"));
                this.publishRenderMessage((PortletRequest)actionRequest, "MSG", errors);
                return;
            }
            if (this.optionForceEmailsToBeSystemUnique) {
                boolean emailExistsFlag = true;
                User user = null;
                try {
                    user = this.admin.lookupUserFromEmail((String)userInfo.get(USER_ATTRIBUTE_EMAIL));
                }
                catch (AdministrationEmailException e1) {
                    emailExistsFlag = false;
                }
                if (emailExistsFlag || user != null) {
                    errors.add(resource.getString("error.email_already_exists"));
                    this.publishRenderMessage((PortletRequest)actionRequest, "MSG", errors);
                    return;
                }
            }
            try {
                if (this.optionForceGeneratedPasswords) {
                    String password = this.admin.generatePassword();
                    userInfo.put("password", password);
                } else if (!((String)userInfo.get("password")).equals(userInfo.get("verifyPassword"))) {
                    errors.add(resource.getString("error.two_passwords_do_not_match"));
                    this.publishRenderMessage((PortletRequest)actionRequest, "MSG", errors);
                    return;
                }
            }
            catch (Exception e) {
                errors.add(resource.getString("error.failed_to_add") + e.toString());
                this.publishRenderMessage((PortletRequest)actionRequest, "MSG", errors);
            }
            if (errors.size() > 0) {
                this.publishRenderMessage((PortletRequest)actionRequest, "MSG", errors);
                return;
            }
            try {
                List prefGroups;
                List prefRoles;
                String subsiteRootFolder;
                PortletPreferences prefs = actionRequest.getPreferences();
                String template = prefs.getValue("newUserTemplateDirectory", "");
                if (template.trim().length() == 0) {
                    template = null;
                }
                if ((subsiteRootFolder = prefs.getValue("subsiteRootFolder", "")).trim().length() == 0) {
                    subsiteRootFolder = null;
                }
                if ((prefRoles = this.getPreferencesList(prefs, IP_ROLES)).isEmpty()) {
                    prefRoles = this.roles;
                }
                if ((prefGroups = this.getPreferencesList(prefs, IP_GROUPS)).isEmpty()) {
                    prefGroups = this.groups;
                }
                List names = this.getPreferencesList(prefs, IP_RULES_NAMES);
                List values = this.getPreferencesList(prefs, IP_RULES_VALUES);
                Map<Object, Object> profileRules = new HashMap();
                for (int ix = 0; ix < (names.size() < values.size() ? names.size() : values.size()); ++ix) {
                    profileRules.put(names.get(ix), values.get(ix));
                }
                if (profileRules.isEmpty()) {
                    profileRules = this.rules;
                }
                this.admin.registerUser((String)userInfo.get("user.name"), (String)userInfo.get("password"), prefRoles, prefGroups, userAttributes, profileRules, template, subsiteRootFolder, actionRequest.getLocale(), actionRequest.getServerName());
                String urlGUID = ForgottenPasswordPortlet.makeGUID((String)((String)userInfo.get("user.name")), (String)((String)userInfo.get("password")));
                userInfo.put("returnURL", this.generateReturnURL((PortletRequest)actionRequest, (PortletResponse)actionResponse, urlGUID));
                String templ = this.getTemplatePath(actionRequest, actionResponse);
                if (templ == null) {
                    throw new Exception("email template not available");
                }
                boolean sendEmail = prefs.getValue("SendEmail", "true").equals("true");
                if (sendEmail) {
                    this.admin.sendEmail(this.getPortletConfig(), (String)userInfo.get(USER_ATTRIBUTE_EMAIL), this.getEmailSubject((PortletRequest)actionRequest), templ, userInfo);
                }
                if (this.optionForceEmailAsUsername || this.optionForceGeneratedPasswords) {
                    this.publishRenderMessage((PortletRequest)actionRequest, "registeredUserMsg", (Object)resource.getString("success.check_your_email"));
                } else {
                    this.publishRenderMessage((PortletRequest)actionRequest, "registeredUserMsg", (Object)resource.getString("success.login_above"));
                }
                this.publishRenderMessage((PortletRequest)actionRequest, "user", new HashMap());
                actionResponse.sendRedirect(this.generateRedirectURL((PortletRequest)actionRequest, (PortletResponse)actionResponse));
            }
            catch (Exception e) {
                errors.add(resource.getString("error.failed_to_add") + e.toString());
                this.publishRenderMessage((PortletRequest)actionRequest, "MSG", errors);
            }
        }
        catch (MissingResourceException mre) {
            errors.add(resource.getString("error.failed_to_add") + mre.toString());
            this.publishRenderMessage((PortletRequest)actionRequest, "MSG", errors);
        }
        catch (Exception e) {
            errors.add(resource.getString("error.failed_to_add") + e.toString());
            this.publishRenderMessage((PortletRequest)actionRequest, "MSG", errors);
        }
    }

    protected String getEmailSubject(PortletRequest request) {
        ResourceBundle resource = this.getPortletConfig().getResourceBundle(request.getLocale());
        try {
            this.emailSubject = resource.getString(RB_EMAIL_SUBJECT);
        }
        catch (MissingResourceException mre) {
            this.emailSubject = null;
        }
        if (this.emailSubject == null) {
            this.emailSubject = "Registration Confirmation";
        }
        return this.emailSubject;
    }

    protected List<String> getInitParameterList(PortletConfig config, String ipName) {
        String temp = config.getInitParameter(ipName);
        if (temp == null) {
            return new ArrayList<String>();
        }
        String[] temps = temp.split("\\,");
        for (int ix = 0; ix < temps.length; ++ix) {
            temps[ix] = temps[ix].trim();
        }
        return Arrays.asList(temps);
    }

    protected List<String> getPreferencesList(PortletPreferences prefs, String prefName) {
        String temp = prefs.getValue(prefName, "");
        if (temp == null || temp.trim().length() == 0) {
            return new ArrayList<String>();
        }
        String[] temps = temp.split("\\,");
        for (int ix = 0; ix < temps.length; ++ix) {
            temps[ix] = temps[ix].trim();
        }
        return Arrays.asList(temps);
    }

    protected String generateReturnURL(PortletRequest request, PortletResponse response, String urlGUID) {
        String fullPath = this.returnUrlPath + "?newUserGUID=" + urlGUID;
        String url = this.admin.getPortalURL(request, response, fullPath);
        return url;
    }

    protected String generateRedirectURL(PortletRequest request, PortletResponse response) {
        return this.admin.getPortalURL(request, response, this.redirectPath);
    }

    protected String getTemplatePath(ActionRequest request, ActionResponse response) {
        if (this.templateLocator == null) {
            return this.templateLocation + PATH_SEPARATOR + this.templateName;
        }
        RequestContext requestContext = (RequestContext)request.getAttribute("org.apache.jetspeed.request.RequestContext");
        Locale locale = request.getLocale();
        try {
            LocatorDescriptor locator = this.templateLocator.createLocatorDescriptor("email");
            locator.setName(this.templateName);
            locator.setMediaType(requestContext.getMediaType());
            locator.setLanguage(locale.getLanguage());
            locator.setCountry(locale.getCountry());
            TemplateDescriptor template = this.templateLocator.locateTemplate(locator);
            return template.getAppRelativePath();
        }
        catch (TemplateLocatorException e) {
            return this.templateLocation + PATH_SEPARATOR + this.templateName;
        }
    }
}

