/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.portlets.prm;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.jetspeed.om.portlet.PortletApplication;
import org.apache.jetspeed.om.portlet.PortletDefinition;
import org.apache.jetspeed.portlets.JetspeedServiceLocator;
import org.apache.jetspeed.portlets.prm.PortletDataProvider;
import org.apache.jetspeed.portlets.prm.PortletDefinitionBean;
import org.apache.jetspeed.search.ParsedObject;
import org.apache.jetspeed.search.SearchResults;
import org.apache.wicket.extensions.markup.html.repeater.util.SortableDataProvider;
import org.apache.wicket.markup.repeater.data.IDataProvider;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PortletDataProvider
extends SortableDataProvider<PortletDefinitionBean>
implements IDataProvider<PortletDefinitionBean> {
    private JetspeedServiceLocator serviceLocator;
    private boolean searchMode = false;
    private String appName;
    private List<PortletDefinitionBean> portlets = null;
    private List<PortletDefinitionBean> searchResults = null;
    private Locale locale;
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(PortletDataProvider.class);
    private PortletOrderBy orderBy = PortletOrderBy.DISPLAY_NAME_ASC;

    public PortletDataProvider(String defaultAppName, Locale locale, JetspeedServiceLocator locator) {
        this.serviceLocator = locator;
        this.locale = locale;
        this.appName = defaultAppName;
        this.setSort("name", true);
        this.refresh();
    }

    public Iterator<PortletDefinitionBean> iterator(int first, int count) {
        int last = first + count;
        if (last > this.portlets.size()) {
            last = this.portlets.size() - 1;
        }
        if (last < 0) {
            last = 0;
        }
        return this.portlets.subList(first, last).iterator();
    }

    public int size() {
        if (this.searchMode) {
            if (this.searchResults == null) {
                return 0;
            }
            return this.searchResults.size();
        }
        if (this.portlets == null) {
            return 0;
        }
        return this.portlets.size();
    }

    public void detach() {
        super.detach();
    }

    public void refresh() {
        if (this.searchMode) {
            if (this.searchResults != null) {
                this.portlets = this.searchResults;
                return;
            }
            this.searchMode = false;
        } else {
            if (this.getAppName() == null) {
                this.changeAppName("j2-admin");
            }
            this.portlets = new ArrayList();
            PortletApplication app = this.serviceLocator.getPortletRegistry().getPortletApplication(this.getAppName());
            if (app != null) {
                for (PortletDefinition def : app.getPortlets()) {
                    this.portlets.add(new PortletDefinitionBean(def, this.getAppName(), this.locale));
                }
                for (PortletDefinition def : app.getClones()) {
                    this.portlets.add(new PortletDefinitionBean(def, this.getAppName(), this.locale));
                }
            }
            this.sort(this.portlets, this.orderBy);
        }
    }

    public void setSearchMode(boolean mode) {
        this.searchMode = mode;
    }

    public boolean getSearchMode() {
        return this.searchMode;
    }

    public IModel<PortletDefinitionBean> model(PortletDefinitionBean object) {
        return new Model((Serializable)object);
    }

    public void sort(List<PortletDefinitionBean> list, PortletOrderBy orderBy) {
        Collections.sort(list, new PortletComparator(this, orderBy));
    }

    public void searchPortlets(String search) {
        this.searchPortlets(search, true, true);
    }

    public void searchPortlets(String search, boolean withOriginalPortlets, boolean withClonedPortlets) {
        try {
            if (search == null) {
                this.searchMode = false;
                return;
            }
            this.searchResults = new ArrayList();
            SearchResults results = this.serviceLocator.getSearchEngine().search(search);
            if (results.size() > 0) {
                String name = "";
                for (ParsedObject po : results.getResults()) {
                    Map fields = po.getFields();
                    if (fields == null || !po.getType().equals("portlet")) continue;
                    Object id = fields.get("ID");
                    Object pa = fields.get("portlet_application");
                    String paName = "";
                    if (pa != null) {
                        if (id instanceof Collection) {
                            Collection coll = (Collection)id;
                            paName = (String)coll.iterator().next();
                        } else {
                            paName = (String)pa;
                        }
                    }
                    name = paName + "::" + id;
                    PortletDefinition pd = this.serviceLocator.getPortletRegistry().getPortletDefinitionByUniqueName(name);
                    if (pd == null || (!pd.isClone() || !withClonedPortlets) && (pd.isClone() || !withOriginalPortlets)) continue;
                    this.searchResults.add(new PortletDefinitionBean(pd, paName, this.locale));
                }
            }
            this.searchMode = true;
            this.sort(this.searchResults, this.orderBy);
            this.refresh();
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public PortletOrderBy getOrderBy() {
        return this.orderBy;
    }

    public void setOrderBy(PortletOrderBy orderBy) {
        this.orderBy = orderBy;
    }

    public void changeAppName(String appName) {
        this.appName = appName;
        this.refresh();
    }

    public String getAppName() {
        return this.appName;
    }

    public void sort() {
        this.sort(this.portlets, this.orderBy);
    }
}

