/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.portlets.custom;

import java.io.IOException;
import java.util.Collection;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.WindowState;
import org.apache.jetspeed.om.portlet.LocalizedField;
import org.apache.jetspeed.om.portlet.PortletDefinition;
import org.apache.jetspeed.request.RequestContext;
import org.apache.portals.bridges.common.GenericServletPortlet;

public class CustomPreviewModePortlet
extends GenericServletPortlet {
    public static final String PARAM_PREVIEW_PAGE = "PreviewPage";
    private static final PortletMode PREVIEW_MODE = new PortletMode("preview");
    private String defaultPreviewPage;
    private boolean allowPreferences;

    public void init(PortletConfig config) throws PortletException {
        super.init(config);
        this.defaultPreviewPage = config.getInitParameter(PARAM_PREVIEW_PAGE);
        String allowPreferencesString = config.getInitParameter("AllowPreferences");
        if (allowPreferencesString != null) {
            this.allowPreferences = new Boolean(allowPreferencesString);
        }
    }

    protected void doDispatch(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        if (!request.getWindowState().equals((Object)WindowState.MINIMIZED)) {
            PortletMode curMode = request.getPortletMode();
            if (PREVIEW_MODE.equals((Object)curMode)) {
                this.doPreview(request, response);
            } else {
                super.doDispatch(request, response);
            }
        }
    }

    protected void doPreview(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        PortletPreferences prefs;
        String previewImage = "";
        RequestContext rc = (RequestContext)request.getAttribute("org.apache.jetspeed.request.RequestContext");
        PortletDefinition def = rc.getCurrentPortletWindow().getPortletDefinition();
        Collection colMetaData = null;
        if (def != null) {
            colMetaData = def.getMetadata().getFields("portlet.preview.image");
        }
        if (colMetaData != null && !colMetaData.isEmpty()) {
            previewImage = def.getApplication().getContextPath() + ((LocalizedField)colMetaData.iterator().next()).getValue();
        }
        request.setAttribute("previewImage", (Object)previewImage);
        String previewPage = this.defaultPreviewPage;
        String reqPreviewPage = (String)request.getAttribute(PARAM_PREVIEW_PAGE);
        if (reqPreviewPage != null) {
            previewPage = reqPreviewPage;
        }
        if (this.allowPreferences && (prefs = request.getPreferences()) != null && reqPreviewPage == null) {
            previewPage = prefs.getValue(PARAM_PREVIEW_PAGE, this.defaultPreviewPage);
        }
        if (previewPage != null) {
            PortletContext context = this.getPortletContext();
            PortletRequestDispatcher rd = context.getRequestDispatcher(previewPage);
            rd.include(request, response);
        }
    }
}

