/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.portlets.content;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.jetspeed.portlets.content.DynamicWebContentRewriter;
import org.apache.jetspeed.request.RequestContext;
import org.apache.portals.applications.webcontent2.portlet.WebContentPortlet;
import org.apache.portals.applications.webcontent2.portlet.history.WebContentPage;
import org.apache.portals.applications.webcontent2.portlet.rewriter.MappingRewriterController;
import org.apache.portals.applications.webcontent2.portlet.rewriter.Rewriter;
import org.apache.portals.applications.webcontent2.portlet.rewriter.RewriterController;
import org.apache.portals.applications.webcontent2.portlet.rewriter.RewriterException;
import org.apache.portals.applications.webcontent2.portlet.rewriter.html.neko.NekoParserAdaptor;
import org.apache.portals.applications.webcontent2.portlet.rewriter.rules.Ruleset;
import org.apache.portals.applications.webcontent2.portlet.rewriter.xml.SaxParserAdaptor;
import org.apache.portals.messaging.PortletMessaging;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicWebContentPortlet
extends WebContentPortlet {
    private static final Logger log = LoggerFactory.getLogger(DynamicWebContentPortlet.class);

    public void processAction(ActionRequest actionRequest, ActionResponse actionResponse) throws PortletException, IOException {
        if (actionRequest.getPortletMode() == PortletMode.EDIT) {
            this.processPreferencesAction(actionRequest, actionResponse);
            return;
        }
        String webContentURL = actionRequest.getParameter("_AP_URL");
        String webContentMethod = actionRequest.getParameter("_AP_METHOD");
        HashMap webContentParams = new HashMap(actionRequest.getParameterMap());
        webContentParams.remove("_AP_URL");
        webContentParams.remove("_AP_METHOD");
        WebContentPage webContentPage = new WebContentPage(webContentURL, webContentMethod, webContentParams);
        PortletMessaging.publish((PortletRequest)actionRequest, (String)this.getClass().getName(), (Object)webContentPage);
    }

    public void doView(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        RequestContext rc = (RequestContext)request.getAttribute("org.apache.jetspeed.request.RequestContext");
        String viewPage = (String)request.getAttribute("ViewPage");
        if (viewPage != null) {
            super.doView(request, response);
            return;
        }
        String sourceURL = null;
        Map sourceParams = null;
        String sourceMethod = null;
        WebContentPage webContentPage = (WebContentPage)PortletMessaging.receive((PortletRequest)request, (String)this.getClass().getName());
        if (webContentPage != null) {
            sourceURL = webContentPage.getUrl();
            sourceParams = webContentPage.getParams();
            sourceMethod = StringUtils.defaultIfBlank((String)webContentPage.getMethod(), (String)"GET");
        } else {
            String portalRequestPath;
            String baseURL = request.getPreferences().getValue("SRC", null);
            String portalBasePath = request.getPreferences().getValue("PORTALPATH", null);
            if (baseURL == null || portalBasePath == null) {
                throw new PortletException("Required SRC and PORTALPATH preferences not set");
            }
            if (!baseURL.endsWith("/")) {
                baseURL = baseURL + "/";
            }
            if (!portalBasePath.startsWith("/")) {
                portalBasePath = "/" + portalBasePath;
            }
            if (!portalBasePath.endsWith("/")) {
                portalBasePath = portalBasePath + "/";
            }
            if (!(portalRequestPath = rc.getPath()).startsWith(portalBasePath)) {
                throw new PortletException("Unable to map portal request path: " + portalRequestPath + " onto portal base path: " + portalBasePath);
            }
            sourceURL = baseURL + portalRequestPath.substring(portalBasePath.length());
        }
        byte[] content = null;
        try {
            if (log.isDebugEnabled()) {
                log.debug("Portal request: " + rc.getPath() + ", Web content: " + sourceURL);
            }
            content = this.doWebContent(sourceMethod, sourceURL, sourceParams, request, response);
            response.setContentType("text/html");
            PrintWriter writer = response.getWriter();
            ByteArrayInputStream bais = new ByteArrayInputStream(content);
            IOUtils.copy((Reader)new InputStreamReader((InputStream)bais, "UTF-8"), (Writer)writer);
            bais.close();
        }
        catch (Throwable t) {
            throw new PortletException("Error retrieveing web content: " + t, t);
        }
    }

    protected RewriterController getRewriterController(String contextPath) throws Exception {
        Class[] rewriterClasses = new Class[]{DynamicWebContentRewriter.class, DynamicWebContentRewriter.class};
        Class[] adaptorClasses = new Class[]{NekoParserAdaptor.class, SaxParserAdaptor.class};
        MappingRewriterController rewriterController = new MappingRewriterController(contextPath + "conf/rewriter-rules-mapping.xml", Arrays.asList(rewriterClasses), Arrays.asList(adaptorClasses));
        return rewriterController;
    }

    protected Rewriter createRewriter(PortletRequest request, RewriterController rewriterController, Ruleset ruleset) throws RewriterException {
        RequestContext rc = (RequestContext)request.getAttribute("org.apache.jetspeed.request.RequestContext");
        String basePortalPath = rc.getPortalURL().getPageBasePath();
        DynamicWebContentRewriter rewriter = (DynamicWebContentRewriter)super.createRewriter(request, rewriterController, ruleset);
        rewriter.setBasePortalPath(basePortalPath);
        return rewriter;
    }
}

