/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.portlets.clone;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletException;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.jetspeed.components.portletpreferences.PortletPreferencesProvider;
import org.apache.jetspeed.components.portletregistry.PortletRegistry;
import org.apache.jetspeed.om.portlet.DisplayName;
import org.apache.jetspeed.om.portlet.PortletDefinition;
import org.apache.jetspeed.om.portlet.Preference;
import org.apache.jetspeed.om.portlet.Preferences;
import org.apache.jetspeed.portlets.clone.ClonePortletInfo;
import org.apache.jetspeed.request.RequestContext;
import org.apache.portals.bridges.common.GenericServletPortlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PortletCloneManagerPortlet
extends GenericServletPortlet {
    private static Logger log = LoggerFactory.getLogger(PortletCloneManagerPortlet.class);
    private PortletRegistry registry;
    private PortletPreferencesProvider prefProvider;

    public void init(PortletConfig config) throws PortletException {
        super.init(config);
        this.registry = (PortletRegistry)config.getPortletContext().getAttribute("cps:PortletRegistryComponent");
        this.prefProvider = (PortletPreferencesProvider)config.getPortletContext().getAttribute("cps:PortletPreferencesProvider");
    }

    public void doView(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        RequestContext rc = (RequestContext)request.getAttribute("org.apache.jetspeed.request.RequestContext");
        String portletUniqueName = rc.getRequestParameter("portlet");
        if (portletUniqueName == null) {
            portletUniqueName = (String)request.getPortletSession(true).getAttribute("originalPortletUniqueName");
        }
        PortletDefinition def = null;
        if (!StringUtils.isBlank((String)portletUniqueName)) {
            request.getPortletSession(true).setAttribute("originalPortletUniqueName", (Object)portletUniqueName);
            def = this.registry.getPortletDefinitionByUniqueName(portletUniqueName);
        }
        if (def == null) {
            log.error("Cannot find the portlet or clone: {}", (Object)portletUniqueName);
        } else {
            ClonePortletInfo clonePortletInfo = new ClonePortletInfo();
            clonePortletInfo.setOriginalPortletUniqueName(portletUniqueName);
            clonePortletInfo.setPortletName(def.getPortletName());
            clonePortletInfo.setPortletDisplayName(def.getDisplayNameText(Locale.getDefault()));
            clonePortletInfo.setPortletTitle(def.getPortletInfo().getTitle());
            clonePortletInfo.setPortletShortTitle(def.getPortletInfo().getShortTitle());
            clonePortletInfo.setPortletKeywords(def.getPortletInfo().getKeywords());
            HashMap prefsMap = new HashMap();
            for (Preference pref : def.getPortletPreferences().getPortletPreferences()) {
                String prefName = pref.getName();
                ArrayList prefValues = new ArrayList(pref.getValues());
                prefsMap.put(prefName, prefValues);
            }
            clonePortletInfo.setPortletPreferences(prefsMap);
            request.setAttribute("clonePortletInfo", (Object)clonePortletInfo);
        }
        super.doView(request, response);
    }

    public void processAction(ActionRequest request, ActionResponse response) throws PortletException, IOException {
        String status = "fail";
        ClonePortletInfo clonePortletInfo = this.readClonePortletInfoFromRequest(request);
        PortletDefinition def = this.registry.getPortletDefinitionByUniqueName(clonePortletInfo.getOriginalPortletUniqueName());
        try {
            if (def == null) {
                throw new IllegalArgumentException("Cannot find the portlet or clone: " + clonePortletInfo.getOriginalPortletUniqueName());
            }
            if (StringUtils.isBlank((String)clonePortletInfo.getPortletName())) {
                throw new IllegalArgumentException("Invalid clone name: " + clonePortletInfo.getPortletName());
            }
            PortletDefinition clone = this.registry.clonePortletDefinition(def, StringUtils.trim((String)clonePortletInfo.getPortletName()));
            clone.getPortletInfo().setTitle(StringUtils.defaultString((String)clonePortletInfo.getPortletTitle()));
            clone.getPortletInfo().setShortTitle(StringUtils.defaultString((String)clonePortletInfo.getPortletShortTitle()));
            clone.getPortletInfo().setKeywords(StringUtils.defaultString((String)clonePortletInfo.getPortletKeywords()));
            Locale defaultLocale = Locale.getDefault();
            DisplayName defaultDisplayName = null;
            for (DisplayName displayName : clone.getDisplayNames()) {
                if (!displayName.getLocale().equals(defaultLocale)) continue;
                defaultDisplayName = displayName;
                break;
            }
            if (defaultDisplayName == null) {
                defaultDisplayName = clone.addDisplayName(defaultLocale.toString());
            }
            defaultDisplayName.setDisplayName(StringUtils.defaultString((String)clonePortletInfo.getPortletDisplayName()));
            for (Map.Entry entry : clonePortletInfo.getPortletPreferences().entrySet()) {
                String prefName = (String)entry.getKey();
                List prefValues = (List)entry.getValue();
                Preferences prefs = clone.getPortletPreferences();
                Preference pref = prefs.getPortletPreference(prefName);
                if (pref == null) {
                    pref = prefs.addPreference(prefName);
                }
                List values = pref.getValues();
                values.clear();
                values.addAll(prefValues);
                this.prefProvider.storeDefaults(clone, pref);
            }
            this.registry.savePortletDefinition(clone);
            status = "success";
        }
        catch (Exception e) {
            request.getPortletSession(true).setAttribute("errorMessage", (Object)e.toString());
            log.error("Failed to clone portlet from " + clonePortletInfo.getOriginalPortletUniqueName() + " to " + clonePortletInfo.getPortletName(), (Throwable)e);
        }
        request.getPortletSession(true).setAttribute("status", (Object)status);
    }

    private ClonePortletInfo readClonePortletInfoFromRequest(ActionRequest request) {
        ClonePortletInfo clonePortletInfo = new ClonePortletInfo();
        clonePortletInfo.setOriginalPortletUniqueName(request.getParameter("originalPortletUniqueName"));
        clonePortletInfo.setPortletName(request.getParameter("portlet_name"));
        clonePortletInfo.setPortletDisplayName(request.getParameter("portlet_displayName"));
        clonePortletInfo.setPortletTitle(request.getParameter("portlet_title"));
        clonePortletInfo.setPortletShortTitle(request.getParameter("portlet_shortTitle"));
        clonePortletInfo.setPortletKeywords(request.getParameter("portlet_keywords"));
        HashMap prefsMap = new HashMap();
        Enumeration paramNames = request.getParameterNames();
        while (paramNames.hasMoreElements()) {
            String paramName = (String)paramNames.nextElement();
            if (!paramName.startsWith("prefs_")) continue;
            String prefName = paramName.substring("prefs_".length());
            String[] prefValues = request.getParameterValues(paramName);
            List<Object> prefValueList = null;
            prefValueList = prefValues == null ? Collections.emptyList() : Arrays.asList(prefValues);
            prefsMap.put(prefName, prefValueList);
        }
        clonePortletInfo.setPortletPreferences(prefsMap);
        return clonePortletInfo;
    }
}

