/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.jetapp;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import javax.portlet.GenericPortlet;
import javax.portlet.PortletConfig;
import javax.portlet.PortletException;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jetspeed.jetapp.dto.DtoError;
import org.w3c.dom.Element;

/*
 * Exception performing whole class analysis ignored.
 */
public class JetAppPortlet
extends GenericPortlet {
    protected static Log log = LogFactory.getLog(JetAppPortlet.class);
    protected static final String JETAPP_ANGULAR_FLAG = "jetapp.angular.flag";
    protected static final String JETAPP_HEADERS_FLAG = "jetapp.headers.flag";
    protected final String ANGULAR = "<script>\n    angular.element(document).ready(function() {\n        angular.bootstrap(document, ['j2admin']);\n    });\n</script>\n";
    protected static final String J2_ADMIN_CSS_ID = "j2admin_css";
    protected static final String J2_ADMIN_EXTERNAL_SCRIPT_ID = "j2admin_ext_script";
    protected static final String J2_ADMIN_INTERNAL_SCRIPT_ID = "j2admin_int_script";
    public static final boolean DEV_MODE = false;
    protected static String[][] PRODUCTION_STYLES = new String[][]{{"/wro/J2_ADMIN_CSS.css", "j2admin_css"}};
    protected static String[][] DEV_STYLES = new String[][]{{"/jetapp/j2-admin-skin.css", "j2admin_css"}};
    protected static String[][] PRODUCTION_SCRIPTS = new String[][]{{"/wro/J2_ADMIN_EXTERNAL_JS.js", "j2admin_ext_script"}, {"/wro/J2_ADMIN_INTERNAL_JS.js", "j2admin_int_script"}};
    protected static String[][] DEV_SCRIPTS = new String[][]{{"/wro/J2_ADMIN_EXTERNAL_JS.js", "j2admin_ext_script"}, {"/jetapp/scripts/TextMessages.js", "j2admin_text"}, {"/jetapp/scripts/ServerService.js", "j2admin_server"}, {"/jetapp/scripts/RestApiService.js", "j2admin_services"}, {"/jetapp/scripts/PortletService.js", "j2admin_portlet"}, {"/jetapp/scripts/StatisticsRestServices.js", "j2admin_statistics"}, {"/jetapp/app.js", "j2admin_app"}, {"/jetapp/scripts/controllers.js", "j2admin_controllers"}, {"/jetapp/scripts/chartControllers.js", "j2admin_chart_controllers"}, {"/jetapp/scripts/directives.js", "j2admin_directives"}, {"/jetapp/scripts/filters.js", "j2admin_filters"}};
    protected static final String PREFS_VIEW = "View";
    protected static final String PREFS_EDIT = "Edit";
    private static final int BLOCK_SIZE = 4096;

    public void init(PortletConfig config) throws PortletException {
        super.init(config);
    }

    protected void doView(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        response.setContentType("text/html");
        if (this.authenticate(request, response)) {
            String url = request.getPreferences().getValue("View", "/jetapp/views/profiler-admin.jsp");
            PortletRequestDispatcher dispatcher = this.getPortletContext().getRequestDispatcher(url);
            dispatcher.include(request, response);
        }
    }

    protected boolean authenticate(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        return true;
    }

    protected void addJavaScript(RenderResponse response, String scriptPath, String scriptId) {
        Element headElem = response.createElement("script");
        headElem.setAttribute("language", "javascript");
        if (scriptId != null) {
            headElem.setAttribute("id", scriptId);
        }
        headElem.setAttribute("src", scriptPath);
        headElem.setAttribute("type", "text/javascript");
        response.addProperty("javax.portlet.markup.head.element", headElem);
    }

    protected void addStyleLink(RenderResponse response, String cssPath, String cssId) {
        Element headElem = response.createElement("link");
        headElem.setAttribute("rel", "stylesheet");
        if (cssId != null) {
            headElem.setAttribute("id", cssId);
        }
        headElem.setAttribute("href", cssPath);
        headElem.setAttribute("type", "text/css");
        response.addProperty("javax.portlet.markup.head.element", headElem);
    }

    protected void doHeaders(RenderRequest request, RenderResponse response) {
        super.doHeaders(request, response);
        if (this.alreadyContributedHeaders(request)) {
            return;
        }
        String[][] styles = DEV_STYLES;
        String[][] scripts = PRODUCTION_SCRIPTS;
        for (String[] pair : styles) {
            this.addStyleLink(response, request.getContextPath() + pair[0], pair[1]);
        }
        for (String[] pair : scripts) {
            this.addJavaScript(response, request.getContextPath() + pair[0], pair[1]);
        }
        this.includeAngluar(request, response);
    }

    protected void includeAngluar(RenderRequest request, RenderResponse response) {
        try {
            response.getWriter().write("<script>\n    angular.element(document).ready(function() {\n        angular.bootstrap(document, ['j2admin']);\n    });\n</script>\n".toCharArray());
        }
        catch (IOException e) {
            log.error((Object)"Failed to include Angular bits", (Throwable)e);
        }
    }

    public String createError(int httpCode, String message) throws IOException {
        DtoError error = new DtoError(httpCode, message);
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.configure(SerializationFeature.INDENT_OUTPUT, true);
        StringWriter writer = new StringWriter();
        objectMapper.writeValue((Writer)writer, (Object)error);
        return writer.toString();
    }

    protected static HttpServletRequest getServletRequest(RenderRequest request) {
        Object context = request.getAttribute("org.apache.jetspeed.request.RequestContext");
        if (context != null) {
            try {
                Method getRequest = context.getClass().getMethod("getRequest", new Class[0]);
                if (getRequest != null) {
                    return (HttpServletRequest)getRequest.invoke(context, new Object[0]);
                }
            }
            catch (Exception e2) {
                log.error((Object)("Failed to retrieve portal servlet request: " + e2.getMessage()), (Throwable)e2);
                return null;
            }
        }
        return null;
    }

    protected boolean alreadyContributedHeaders(RenderRequest renderRequest) {
        HttpServletRequest request = JetAppPortlet.getServletRequest((RenderRequest)renderRequest);
        if (request == null) {
            return false;
        }
        Boolean contributed = (Boolean)request.getAttribute("jetapp.headers.flag");
        if (contributed == null || !contributed.booleanValue()) {
            request.setAttribute("jetapp.headers.flag", (Object)Boolean.TRUE);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void drain(Reader r, Writer w) throws IOException {
        char[] bytes = new char[4096];
        try {
            int length = r.read(bytes);
            while (length != -1) {
                if (length != 0) {
                    w.write(bytes, 0, length);
                }
                length = r.read(bytes);
            }
        }
        finally {
            bytes = null;
        }
    }
}

