/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.util.featuregen;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import opennlp.tools.util.model.ArtifactSerializer;
import opennlp.tools.util.model.SerializableArtifact;

public class BrownCluster
implements SerializableArtifact {
    private static final Pattern tabPattern = Pattern.compile("\t");
    private final Map<String, String> tokenToClusterMap = new HashMap<String, String>();

    public BrownCluster(InputStream in) throws IOException {
        try (BufferedReader breader = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));){
            String line;
            while ((line = breader.readLine()) != null) {
                String[] lineArray = tabPattern.split(line);
                if (lineArray.length == 3) {
                    int freq = Integer.parseInt(lineArray[2]);
                    if (freq <= 5) continue;
                    this.tokenToClusterMap.put(lineArray[1], lineArray[0]);
                    continue;
                }
                if (lineArray.length != 2) continue;
                this.tokenToClusterMap.put(lineArray[0], lineArray[1]);
            }
        }
    }

    public String lookupToken(String string) {
        return this.tokenToClusterMap.get(string);
    }

    public void serialize(OutputStream out) throws IOException {
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(out));){
            for (Map.Entry<String, String> entry : this.tokenToClusterMap.entrySet()) {
                writer.write(entry.getKey() + "\t" + entry.getValue() + "\n");
            }
            ((Writer)writer).flush();
        }
    }

    @Override
    public Class<?> getArtifactSerializerClass() {
        return BrownClusterSerializer.class;
    }

    public static class BrownClusterSerializer
    implements ArtifactSerializer<BrownCluster> {
        @Override
        public BrownCluster create(InputStream in) throws IOException {
            return new BrownCluster(in);
        }

        @Override
        public void serialize(BrownCluster artifact, OutputStream out) throws IOException {
            artifact.serialize(out);
        }
    }
}

