/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.lib.conf;

import java.security.AccessController;
import java.util.Objects;
import org.apache.openjpa.lib.conf.Configuration;
import org.apache.openjpa.lib.conf.Configurations;
import org.apache.openjpa.lib.conf.Value;
import org.apache.openjpa.lib.util.J2DoPrivHelper;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.lib.util.collections.AbstractReferenceMap;
import org.apache.openjpa.lib.util.concurrent.ConcurrentReferenceHashMap;

public class ObjectValue
extends Value {
    private static final Localizer _loc = Localizer.forPackage(ObjectValue.class);
    private static ConcurrentReferenceHashMap _classloaderCache = new ConcurrentReferenceHashMap(AbstractReferenceMap.ReferenceStrength.HARD, AbstractReferenceMap.ReferenceStrength.WEAK);
    private Object _value = null;

    public ObjectValue(String prop) {
        super(prop);
    }

    @Override
    public Object get() {
        return this._value;
    }

    public void set(Object obj) {
        this.set(obj, false);
    }

    public void set(Object obj, boolean derived) {
        if (!derived) {
            this.assertChangeable();
        }
        Object oldValue = this._value;
        this._value = obj;
        if (!derived && !Objects.equals(obj, oldValue)) {
            this.objectChanged();
            this.valueChanged();
        }
    }

    public Object instantiate(Class<?> type, Configuration conf) {
        return this.instantiate(type, conf, true);
    }

    public Object instantiate(Class<?> type, Configuration conf, boolean fatal) {
        throw new UnsupportedOperationException();
    }

    public Object configure(Object obj, Configuration conf) {
        return this.configure(obj, conf, true);
    }

    public Object configure(Object obj, Configuration conf, boolean fatal) {
        throw new UnsupportedOperationException();
    }

    public Object newInstance(String clsName, Class<?> type, Configuration conf, boolean fatal) {
        ClassLoader cl = (ClassLoader)_classloaderCache.get(type);
        if (cl == null) {
            cl = AccessController.doPrivileged(J2DoPrivHelper.getClassLoaderAction(type));
            if (cl == null) {
                cl = AccessController.doPrivileged(J2DoPrivHelper.getSystemClassLoaderAction());
            }
            _classloaderCache.put(type, cl);
        }
        return Configurations.newInstance(clsName, this, conf, cl, fatal);
    }

    @Override
    public Class<?> getValueType() {
        return Object.class;
    }

    protected void objectChanged() {
    }

    @Override
    protected String getInternalString() {
        return null;
    }

    @Override
    protected void setInternalString(String str) {
        if (str != null) {
            throw new IllegalArgumentException(_loc.get("cant-set-string", this.getProperty()).getMessage());
        }
        this.set(null);
    }

    @Override
    protected void setInternalObject(Object obj) {
        this.set(obj);
    }
}

