/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.engine;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SegmentReader;
import org.opensearch.common.breaker.CircuitBreaker;
import org.opensearch.common.lucene.Lucene;
import org.opensearch.common.lucene.index.OpenSearchDirectoryReader;
import org.opensearch.indices.breaker.CircuitBreakerService;

final class RamAccountingRefreshListener
implements BiConsumer<OpenSearchDirectoryReader, OpenSearchDirectoryReader> {
    private final CircuitBreakerService breakerService;

    RamAccountingRefreshListener(CircuitBreakerService breakerService) {
        this.breakerService = breakerService;
    }

    @Override
    public void accept(OpenSearchDirectoryReader reader, OpenSearchDirectoryReader previousReader) {
        Set prevReaders;
        CircuitBreaker breaker = this.breakerService.getBreaker("accounting");
        if (previousReader == null) {
            prevReaders = Collections.emptySet();
        } else {
            List previousReaderLeaves = previousReader.leaves();
            prevReaders = new HashSet(previousReaderLeaves.size());
            for (LeafReaderContext lrc : previousReaderLeaves) {
                prevReaders.add(Lucene.segmentReader(lrc.reader()).getCoreCacheHelper().getKey());
            }
        }
        for (LeafReaderContext lrc : reader.leaves()) {
            SegmentReader segmentReader = Lucene.segmentReader(lrc.reader());
            if (prevReaders.contains(segmentReader.getCoreCacheHelper().getKey())) continue;
            long ramBytesUsed = segmentReader.ramBytesUsed();
            breaker.addWithoutBreaking(ramBytesUsed);
            segmentReader.getCoreCacheHelper().addClosedListener(k -> breaker.addWithoutBreaking(-ramBytesUsed));
        }
    }
}

