/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.get;

import org.opensearch.action.ActionRequestBuilder;
import org.opensearch.action.get.MultiGetAction;
import org.opensearch.action.get.MultiGetRequest;
import org.opensearch.action.get.MultiGetResponse;
import org.opensearch.client.OpenSearchClient;
import org.opensearch.common.Nullable;

public class MultiGetRequestBuilder
extends ActionRequestBuilder<MultiGetRequest, MultiGetResponse> {
    public MultiGetRequestBuilder(OpenSearchClient client, MultiGetAction action) {
        super(client, action, new MultiGetRequest());
    }

    public MultiGetRequestBuilder add(String index, @Nullable String type, String id) {
        ((MultiGetRequest)this.request).add(index, type, id);
        return this;
    }

    public MultiGetRequestBuilder add(String index, @Nullable String type, Iterable<String> ids) {
        for (String id : ids) {
            ((MultiGetRequest)this.request).add(index, type, id);
        }
        return this;
    }

    public MultiGetRequestBuilder add(String index, @Nullable String type, String ... ids) {
        for (String id : ids) {
            ((MultiGetRequest)this.request).add(index, type, id);
        }
        return this;
    }

    public MultiGetRequestBuilder add(MultiGetRequest.Item item) {
        ((MultiGetRequest)this.request).add(item);
        return this;
    }

    public MultiGetRequestBuilder setPreference(String preference) {
        ((MultiGetRequest)this.request).preference(preference);
        return this;
    }

    public MultiGetRequestBuilder setRefresh(boolean refresh) {
        ((MultiGetRequest)this.request).refresh(refresh);
        return this;
    }

    public MultiGetRequestBuilder setRealtime(boolean realtime) {
        ((MultiGetRequest)this.request).realtime(realtime);
        return this;
    }
}

