/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.admin.cluster.node.hotthreads;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.opensearch.action.support.nodes.BaseNodesRequest;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.unit.TimeValue;

public class NodesHotThreadsRequest
extends BaseNodesRequest<NodesHotThreadsRequest> {
    int threads = 3;
    String type = "cpu";
    TimeValue interval = new TimeValue(500L, TimeUnit.MILLISECONDS);
    int snapshots = 10;
    boolean ignoreIdleThreads = true;

    public NodesHotThreadsRequest(StreamInput in) throws IOException {
        super(in);
        this.threads = in.readInt();
        this.ignoreIdleThreads = in.readBoolean();
        this.type = in.readString();
        this.interval = in.readTimeValue();
        this.snapshots = in.readInt();
    }

    public NodesHotThreadsRequest(String ... nodesIds) {
        super(nodesIds);
    }

    public int threads() {
        return this.threads;
    }

    public NodesHotThreadsRequest threads(int threads) {
        this.threads = threads;
        return this;
    }

    public boolean ignoreIdleThreads() {
        return this.ignoreIdleThreads;
    }

    public NodesHotThreadsRequest ignoreIdleThreads(boolean ignoreIdleThreads) {
        this.ignoreIdleThreads = ignoreIdleThreads;
        return this;
    }

    public NodesHotThreadsRequest type(String type) {
        this.type = type;
        return this;
    }

    public String type() {
        return this.type;
    }

    public NodesHotThreadsRequest interval(TimeValue interval) {
        this.interval = interval;
        return this;
    }

    public TimeValue interval() {
        return this.interval;
    }

    public int snapshots() {
        return this.snapshots;
    }

    public NodesHotThreadsRequest snapshots(int snapshots) {
        this.snapshots = snapshots;
        return this;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeInt(this.threads);
        out.writeBoolean(this.ignoreIdleThreads);
        out.writeString(this.type);
        out.writeTimeValue(this.interval);
        out.writeInt(this.snapshots);
    }
}

