/*
 * Decompiled with CFR 0.152.
 */
package org.archive.resource;

import java.io.IOException;
import org.archive.resource.Resource;
import org.archive.resource.ResourceFactory;
import org.archive.resource.ResourceParseException;
import org.archive.resource.ResourceProducer;

public class TransformingResourceProducer
implements ResourceProducer {
    private ResourceProducer producer;
    private ResourceFactory factory;

    public TransformingResourceProducer(ResourceProducer producer, ResourceFactory factory) {
        this.producer = producer;
        this.factory = factory;
    }

    @Override
    public Resource getNext() throws ResourceParseException, IOException {
        Resource inner = this.producer.getNext();
        if (inner == null) {
            return null;
        }
        return this.factory.getResource(inner.getInputStream(), inner.getMetaData(), inner.getContainer());
    }

    @Override
    public void close() throws IOException {
        this.producer.close();
    }

    @Override
    public String getContext() {
        return this.producer.getContext();
    }
}

