/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.detect.zip;

import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.tika.detect.zip.PackageConstants;
import org.apache.tika.detect.zip.StreamingDetectContext;
import org.apache.tika.detect.zip.ZipContainerDetector;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.mime.MediaType;

public class KMZDetector
implements ZipContainerDetector {
    @Override
    public MediaType detect(ZipFile zip, TikaInputStream tis) throws IOException {
        boolean kmlFound = false;
        Enumeration<ZipArchiveEntry> entries = zip.getEntries();
        while (entries.hasMoreElements()) {
            ZipArchiveEntry entry = entries.nextElement();
            String name = entry.getName();
            if (entry.isDirectory() || name.indexOf(47) != -1 || name.indexOf(92) != -1) continue;
            if (name.endsWith(".kml") && !kmlFound) {
                kmlFound = true;
                continue;
            }
            return null;
        }
        if (kmlFound) {
            return MediaType.application((String)"vnd.google-earth.kmz");
        }
        return null;
    }

    @Override
    public MediaType streamingDetectUpdate(ZipArchiveEntry zae, InputStream zis, StreamingDetectContext detectContext) {
        String name = zae.getName();
        if (name.indexOf(47) != -1 || name.indexOf(92) != -1) {
            return null;
        }
        if (name.endsWith(".kml")) {
            KMLCounter counter = detectContext.get(KMLCounter.class);
            if (counter == null) {
                counter = new KMLCounter();
                detectContext.set(KMLCounter.class, counter);
            }
            counter.increment();
        }
        return null;
    }

    @Override
    public MediaType streamingDetectFinal(StreamingDetectContext detectContext) {
        if (detectContext.get(KMLCounter.class) != null && detectContext.get(KMLCounter.class).getCount() == 1) {
            return PackageConstants.KMZ;
        }
        return null;
    }

    private static class KMLCounter {
        private int cnt = 0;

        private KMLCounter() {
        }

        int getCount() {
            return this.cnt;
        }

        void increment() {
            ++this.cnt;
        }
    }
}

