/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group.assignor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.coordinator.group.assignor.AssignmentSpec;
import org.apache.kafka.coordinator.group.assignor.GroupAssignment;
import org.apache.kafka.coordinator.group.assignor.MemberAssignment;
import org.apache.kafka.coordinator.group.assignor.SubscribedTopicDescriber;
import org.apache.kafka.server.common.TopicIdPartition;

public abstract class AbstractUniformAssignmentBuilder {
    protected abstract GroupAssignment buildAssignment();

    protected static boolean useRackAwareAssignment(Set<String> memberRacks, Set<String> allPartitionRacks, Map<TopicIdPartition, Set<String>> racksPerPartition) {
        if (memberRacks.isEmpty() || Collections.disjoint(memberRacks, allPartitionRacks)) {
            return false;
        }
        return !racksPerPartition.values().stream().allMatch(allPartitionRacks::equals);
    }

    protected static void addPartitionToAssignment(Map<String, MemberAssignment> memberAssignments, String memberId, Uuid topicId, int partition) {
        memberAssignments.get(memberId).targetPartitions().computeIfAbsent(topicId, __ -> new HashSet()).add(partition);
    }

    protected static Set<TopicIdPartition> topicIdPartitions(Collection<Uuid> topicIds, SubscribedTopicDescriber subscribedTopicDescriber) {
        return topicIds.stream().flatMap(topic -> IntStream.range(0, subscribedTopicDescriber.numPartitions((Uuid)topic)).mapToObj(i -> new TopicIdPartition(topic, i))).collect(Collectors.toSet());
    }

    protected static void processTopicIdPartitions(Collection<Uuid> topicIds, SubscribedTopicDescriber subscribedTopicDescriber, Consumer<TopicIdPartition> func) {
        topicIds.stream().flatMap(topic -> IntStream.range(0, subscribedTopicDescriber.numPartitions((Uuid)topic)).mapToObj(i -> new TopicIdPartition(topic, i))).forEach(func);
    }

    protected static class RackInfo {
        protected final Map<String, String> memberRacks;
        protected final Map<TopicIdPartition, Set<String>> partitionRacks;
        protected final Map<TopicIdPartition, List<String>> membersWithSameRackAsPartition;
        protected final boolean useRackStrategy;

        public RackInfo(AssignmentSpec assignmentSpec, SubscribedTopicDescriber subscribedTopicDescriber, Set<Uuid> topicIds) {
            Map<TopicIdPartition, Set<String>> racksPerPartition;
            Set<String> allPartitionRacks;
            HashMap<String, List> membersByRack = new HashMap<String, List>();
            assignmentSpec.members().forEach((memberId, assignmentMemberSpec) -> assignmentMemberSpec.rackId().filter(r -> !r.isEmpty()).ifPresent(rackId -> membersByRack.computeIfAbsent((String)rackId, __ -> new ArrayList()).add(memberId)));
            if (membersByRack.isEmpty()) {
                allPartitionRacks = Collections.emptySet();
                racksPerPartition = Collections.emptyMap();
            } else {
                racksPerPartition = new HashMap();
                allPartitionRacks = new HashSet();
                AbstractUniformAssignmentBuilder.processTopicIdPartitions(topicIds, subscribedTopicDescriber, tp -> {
                    Set<String> racks = subscribedTopicDescriber.racksForPartition(tp.topicId(), tp.partitionId());
                    racksPerPartition.put((TopicIdPartition)tp, racks);
                    if (!racks.isEmpty()) {
                        allPartitionRacks.addAll(racks);
                    }
                });
            }
            if (AbstractUniformAssignmentBuilder.useRackAwareAssignment(membersByRack.keySet(), allPartitionRacks, racksPerPartition)) {
                this.memberRacks = new HashMap<String, String>(assignmentSpec.members().size());
                membersByRack.forEach((rack, rackMembers) -> rackMembers.forEach(c -> this.memberRacks.put((String)c, (String)rack)));
                this.partitionRacks = racksPerPartition;
                this.useRackStrategy = true;
            } else {
                this.memberRacks = Collections.emptyMap();
                this.partitionRacks = Collections.emptyMap();
                this.useRackStrategy = false;
            }
            this.membersWithSameRackAsPartition = racksPerPartition.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((Set)entry.getValue()).stream().flatMap(rack -> membersByRack.getOrDefault(rack, Collections.emptyList()).stream()).distinct().collect(Collectors.toList())));
        }

        protected boolean racksMismatch(String memberId, TopicIdPartition tp) {
            String memberRack = this.memberRacks.get(memberId);
            Set<String> replicaRacks = this.partitionRacks.get(tp);
            return memberRack == null || replicaRacks == null || !replicaRacks.contains(memberRack);
        }

        protected List<TopicIdPartition> sortPartitionsByRackMembers(Collection<TopicIdPartition> topicIdPartitions) {
            return topicIdPartitions.stream().filter(tp -> this.membersWithSameRackAsPartition.containsKey(tp) && !this.membersWithSameRackAsPartition.get(tp).isEmpty()).sorted(Comparator.comparing(tp -> this.membersWithSameRackAsPartition.getOrDefault(tp, Collections.emptyList()).size()).thenComparing(TopicIdPartition::topicId).thenComparing(TopicIdPartition::partitionId)).collect(Collectors.toList());
        }

        protected List<String> getSortedMembersWithMatchingRack(TopicIdPartition topicIdPartition, Map<String, MemberAssignment> assignment) {
            List<String> membersList = this.membersWithSameRackAsPartition.getOrDefault(topicIdPartition, Collections.emptyList());
            membersList.sort((member1, member2) -> {
                int sum1 = ((MemberAssignment)assignment.get(member1)).targetPartitions().values().stream().mapToInt(Set::size).sum();
                int sum2 = ((MemberAssignment)assignment.get(member2)).targetPartitions().values().stream().mapToInt(Set::size).sum();
                return Integer.compare(sum1, sum2);
            });
            return membersList;
        }

        public String toString() {
            return "RackInfo(memberRacks=" + this.memberRacks + ", partitionRacks=" + this.partitionRacks + ")";
        }
    }
}

