/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.components.resource;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import org.apache.nifi.components.resource.ResourceReference;
import org.apache.nifi.components.resource.ResourceType;

public class Utf8TextResource
implements ResourceReference {
    private final String text;

    public Utf8TextResource(String text) {
        this.text = text;
    }

    @Override
    public File asFile() {
        return null;
    }

    @Override
    public URL asURL() {
        return null;
    }

    @Override
    public InputStream read() throws IOException {
        return new ByteArrayInputStream(this.text.getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public boolean isAccessible() {
        return true;
    }

    @Override
    public String getLocation() {
        return null;
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.TEXT;
    }

    public String toString() {
        return "Utf8TextResource[text=" + this.text.length() + " characters]";
    }
}

