/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.netbeans.modules.java.hints.onsave;

import java.util.prefs.Preferences;

/**
 *
 * @author lahvac
 */
public class OnSaveCustomizer extends javax.swing.JPanel {
    private final Preferences settings;

    /**
     * Creates new form OnSaveCustomizer
     */
    public OnSaveCustomizer(Preferences settings) {
        initComponents();
        this.settings = settings;
        removeUnusedImports.setSelected(RemoveUnusedAfterSave.getValue(settings, "Imports_UNUSED"));
        organizeImports.setSelected(RemoveUnusedAfterSave.getValue(settings, "org.netbeans.modules.java.hints.OrganizeImports"));
    }
    
    String getSavedValue(String key) {
        return Boolean.toString(RemoveUnusedAfterSave.getSavedValue(key));
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        removeUnusedImports = new javax.swing.JCheckBox();
        organizeImports = new javax.swing.JCheckBox();

        org.openide.awt.Mnemonics.setLocalizedText(removeUnusedImports, org.openide.util.NbBundle.getMessage(OnSaveCustomizer.class, "OnSaveCustomizer.removeUnusedImports.text")); // NOI18N
        removeUnusedImports.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                removeUnusedImportsActionPerformed(evt);
            }
        });

        org.openide.awt.Mnemonics.setLocalizedText(organizeImports, org.openide.util.NbBundle.getMessage(OnSaveCustomizer.class, "OnSaveCustomizer.organizeImports.text")); // NOI18N
        organizeImports.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                organizeImportsActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(removeUnusedImports)
                    .addComponent(organizeImports))
                .addContainerGap(196, Short.MAX_VALUE))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(removeUnusedImports)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(organizeImports)
                .addContainerGap(242, Short.MAX_VALUE))
        );
    }// </editor-fold>//GEN-END:initComponents

    private void removeUnusedImportsActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_removeUnusedImportsActionPerformed
        settings.putBoolean(RemoveUnusedAfterSave.KEY_SETTINGS_PREFIX + "Imports_UNUSED", removeUnusedImports.isSelected());
    }//GEN-LAST:event_removeUnusedImportsActionPerformed

    private void organizeImportsActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_organizeImportsActionPerformed
        settings.putBoolean(RemoveUnusedAfterSave.KEY_SETTINGS_PREFIX + "org.netbeans.modules.java.hints.OrganizeImports", organizeImports.isSelected());
    }//GEN-LAST:event_organizeImportsActionPerformed

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JCheckBox organizeImports;
    private javax.swing.JCheckBox removeUnusedImports;
    // End of variables declaration//GEN-END:variables
}
