/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.netbeans.modules.gradle.java.customizer;

import org.netbeans.modules.gradle.api.GradleBaseProject;
import org.netbeans.modules.gradle.api.NbGradleProject;
import org.netbeans.modules.gradle.java.api.GradleJavaProject;
import org.netbeans.modules.gradle.java.api.GradleJavaSourceSet;
import org.netbeans.modules.gradle.spi.Utils;
import org.netbeans.modules.gradle.spi.customizer.support.FilterPanelProvider;
import java.io.File;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.modules.gradle.java.customizer.SourceSetPanel.Details;
import org.netbeans.spi.project.ui.support.ProjectCustomizer;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

/**
 *
 * @author Laszlo Kishalmi
 */
public class SourcesPanel extends javax.swing.JPanel {

    Details activeDetail = Details.SOURCES;

    /**
     * Creates new form SourcesPanel
     */
    public SourcesPanel(Project project) {
        initComponents();
        GradleJavaProject gjp = GradleJavaProject.get(project);
        ChangeListener chl = (ChangeEvent evt) -> {
            JTabbedPane details = (JTabbedPane) evt.getSource();
            int selected = details.getSelectedIndex() != -1 ? details.getSelectedIndex() : 0;
            activeDetail = Details.values()[selected];
        };
        if (gjp != null) {
            for (GradleJavaSourceSet sourceSet : gjp.getSourceSets().values()) {
                File rootDir = GradleBaseProject.get(project).getRootDir();
                SourceSetPanel panel = new SourceSetPanel(sourceSet, rootDir);
                tbSourceSets.addTab(Utils.camelCaseToTitle(sourceSet.getName()), null, panel, sourceSet.getName());
                panel.addDetailsChangeListener(chl);
            }
            tbSourceSets.addChangeListener((ChangeEvent evt) -> {
                SourceSetPanel selected = (SourceSetPanel) tbSourceSets.getSelectedComponent();
                if (selected != null) {
                    selected.setActiveDetails(activeDetail);
                }
            });
        }
    }

    @NbBundle.Messages("category.Sources=Sources")
    @ProjectCustomizer.CompositeCategoryProvider.Registration(projectType = NbGradleProject.GRADLE_PROJECT_TYPE, position = 210)
    public static ProjectCustomizer.CompositeCategoryProvider buildCompileCustomizerProvider() {
        ProjectCustomizer.CompositeCategoryProvider provider =  new ProjectCustomizer.CompositeCategoryProvider() {
            @Override
            public ProjectCustomizer.Category createCategory(Lookup context) {
                return ProjectCustomizer.Category.create("sources", Bundle.category_Sources(), null);
            }

            @Override
            public JComponent createComponent(ProjectCustomizer.Category category, Lookup context) {
                Project project = context.lookup(Project.class);

                SourcesPanel customizer = new SourcesPanel(project);
                return customizer;
            }
        };
        return new FilterPanelProvider(provider, "java-base"); //NOI18N
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        tbSourceSets = new javax.swing.JTabbedPane();

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(tbSourceSets, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.DEFAULT_SIZE, 400, Short.MAX_VALUE)
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(tbSourceSets, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.DEFAULT_SIZE, 300, Short.MAX_VALUE)
        );
    }// </editor-fold>//GEN-END:initComponents


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JTabbedPane tbSourceSets;
    // End of variables declaration//GEN-END:variables
}
