/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.apache.myfaces.shared.renderkit.html.util;

import jakarta.faces.component.UIComponent;
import jakarta.faces.model.SelectItem;

/**
 * 
 * NOTE: This class should not be made Serializable. It holds request time information associated with the iteration
 * done by SelectItemsIterator, like the associated component or the calculated model value before conversion.
 */
public class SelectItemInfo
{
    private final SelectItem item;
    
    private final UIComponent component;
    
    private final Object value;

    public SelectItemInfo(SelectItem item, UIComponent component, Object value)
    {
        this.item = item;
        this.component = component;
        this.value = value;
    }
    
    public SelectItemInfo(SelectItem item, UIComponent component)
    {
        this.item = item;
        this.component = component;
        this.value = null;
    }

    /**
     * @return the item
     */
    public SelectItem getItem()
    {
        return item;
    }

    /**
     * @return the component
     */
    public UIComponent getComponent()
    {
        return component;
    }

    /**
     * Return the underlying associated model value.
     */
    public Object getValue()
    {
        return value;
    }
    
}
