/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.orchestra.lib.jsf;

import javax.faces.application.Application;
import javax.faces.component.StateHolder;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;

public class SerializableConverter
implements Converter,
StateHolder {
    private static final long serialVersionUID = 2L;
    private String beanName;
    private transient Converter converter;
    private transient Object[] converterState;

    public SerializableConverter() {
    }

    public SerializableConverter(String beanName) {
        this.beanName = beanName;
    }

    public SerializableConverter(String beanName, Converter instance) {
        this.beanName = beanName;
        this.converter = instance;
    }

    public void setBeanName(String beanName) {
        this.beanName = beanName;
    }

    protected Converter getConverter(FacesContext context) {
        if (this.converter == null) {
            Application application = context.getApplication();
            this.converter = (Converter)application.getVariableResolver().resolveVariable(context, this.beanName);
            if (this.converterState != null) {
                ((StateHolder)this.converter).restoreState(context, (Object)this.converterState);
                this.converterState = null;
            }
        }
        return this.converter;
    }

    public Object getAsObject(FacesContext context, UIComponent component, String value) throws ConverterException {
        return this.getConverter(context).getAsObject(context, component, value);
    }

    public String getAsString(FacesContext context, UIComponent component, Object value) throws ConverterException {
        return this.getConverter(context).getAsString(context, component, value);
    }

    public boolean isTransient() {
        return false;
    }

    public void restoreState(FacesContext context, Object savedState) {
        Object[] state = (Object[])savedState;
        this.beanName = (String)state[0];
        if (state.length == 2) {
            this.converterState = (Object[])state[1];
        }
    }

    public Object saveState(FacesContext context) {
        Object[] state;
        Converter c = this.getConverter(context);
        if (c instanceof StateHolder) {
            state = new Object[2];
            state[1] = ((StateHolder)c).saveState(context);
        } else {
            state = new Object[]{this.beanName};
        }
        return state;
    }

    public void setTransient(boolean newTransientValue) {
    }
}

