/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.orchestra.conversation;

import java.util.HashSet;
import java.util.Set;
import org.apache.myfaces.orchestra.conversation.AccessScopeManagerConfiguration;
import org.apache.myfaces.orchestra.conversation.FlashScopeManager;
import org.apache.myfaces.orchestra.conversation.FlashScopeManagerConfiguration;
import org.apache.myfaces.orchestra.frameworkAdapter.FrameworkAdapter;

public class AccessScopeManager {
    private static final String REQ_ATTR_KEY = AccessScopeManager.class.getName();
    private AccessScopeManagerConfiguration accessScopeManagerConfiguration;
    private boolean recordAccess;
    private boolean ignoreRequest;
    private Set accessedConversations = new HashSet();

    public static AccessScopeManager getInstance() {
        FrameworkAdapter fa = FrameworkAdapter.getCurrentInstance();
        AccessScopeManager manager = (AccessScopeManager)fa.getRequestAttribute(REQ_ATTR_KEY);
        if (manager != null) {
            return manager;
        }
        manager = (AccessScopeManager)fa.getBean(FlashScopeManager.class.getName());
        if (manager != null) {
            fa.setRequestAttribute(REQ_ATTR_KEY, manager);
            return manager;
        }
        FlashScopeManagerConfiguration cfg = (FlashScopeManagerConfiguration)fa.getBean(FlashScopeManagerConfiguration.class.getName());
        if (cfg != null) {
            manager = new AccessScopeManager();
            manager.setAccessScopeManagerConfiguration(cfg);
            fa.setRequestAttribute(REQ_ATTR_KEY, manager);
            return manager;
        }
        manager = (AccessScopeManager)fa.getBean(AccessScopeManager.class.getName());
        if (manager != null) {
            fa.setRequestAttribute(REQ_ATTR_KEY, manager);
            return manager;
        }
        throw new IllegalArgumentException("Orchestra was unable to create an instance of bean with name 'AccessScopeManager'. Ensure that JSF variable resolution uses your dependency injection (DI) framework (eg Spring's DelegatingVariableResolver is in your faces-config.xml file) and the standard Orchestra configuration beans are defined (eg by using <import resource=\"classpath*:/META-INF/spring-orchestra-init.xml\" />).");
    }

    public AccessScopeManagerConfiguration getAccessScopeManagerConfiguration() {
        return this.accessScopeManagerConfiguration;
    }

    public void setAccessScopeManagerConfiguration(AccessScopeManagerConfiguration accessScopeManagerConfiguration) {
        this.accessScopeManagerConfiguration = accessScopeManagerConfiguration;
    }

    public void beginRecording() {
        this.recordAccess = true;
    }

    public void addConversationAccess(String conversationName) {
        if (this.recordAccess && !this.ignoreRequest && !this.accessedConversations.contains(conversationName)) {
            this.accessedConversations.add(conversationName);
        }
    }

    public boolean isIgnoreRequest() {
        return this.ignoreRequest;
    }

    public void setIgnoreRequest() {
        this.ignoreRequest = true;
    }

    public boolean isConversationAccessed(String name) {
        if (this.ignoreRequest) {
            throw new IllegalStateException();
        }
        return this.accessedConversations.contains(name);
    }
}

