/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.application.viewstate;

import jakarta.faces.context.FacesContext;
import org.apache.myfaces.application.viewstate.CsrfSessionTokenFactory;
import org.apache.myfaces.application.viewstate.SessionIdGenerator;
import org.apache.myfaces.shared.util.Hex;
import org.apache.myfaces.shared.util.WebConfigParamUtils;

class SecureRandomCsrfSessionTokenFactory
extends CsrfSessionTokenFactory {
    private final SessionIdGenerator sessionIdGenerator;
    private final int length;

    public SecureRandomCsrfSessionTokenFactory(FacesContext facesContext) {
        String secureRandomAlgorithm;
        String secureRandomProvider;
        this.length = WebConfigParamUtils.getIntegerInitParameter(facesContext.getExternalContext(), "org.apache.myfaces.RANDOM_KEY_IN_CSRF_SESSION_TOKEN_LENGTH", 16);
        this.sessionIdGenerator = new SessionIdGenerator();
        this.sessionIdGenerator.setSessionIdLength(this.length);
        String secureRandomClass = WebConfigParamUtils.getStringInitParameter(facesContext.getExternalContext(), "org.apache.myfaces.RANDOM_KEY_IN_CSRF_SESSION_TOKEN_SECURE_RANDOM_CLASS");
        if (secureRandomClass != null) {
            this.sessionIdGenerator.setSecureRandomClass(secureRandomClass);
        }
        if ((secureRandomProvider = WebConfigParamUtils.getStringInitParameter(facesContext.getExternalContext(), "org.apache.myfaces.RANDOM_KEY_IN_CSRF_SESSION_TOKEN_SECURE_RANDOM_PROVIDER")) != null) {
            this.sessionIdGenerator.setSecureRandomProvider(secureRandomProvider);
        }
        if ((secureRandomAlgorithm = WebConfigParamUtils.getStringInitParameter(facesContext.getExternalContext(), "org.apache.myfaces.RANDOM_KEY_IN_CSRF_SESSION_TOKEN_SECURE_RANDOM_ALGORITM")) != null) {
            this.sessionIdGenerator.setSecureRandomAlgorithm(secureRandomAlgorithm);
        }
    }

    public byte[] generateKey(FacesContext facesContext) {
        byte[] array = new byte[this.length];
        this.sessionIdGenerator.getRandomBytes(array);
        return array;
    }

    @Override
    public String createCryptographicallyStrongTokenFromSession(FacesContext context) {
        byte[] key = this.generateKey(context);
        return new String(Hex.encodeHex(key));
    }
}

