/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.jgit.errors.NoRemoteRepositoryException;
import org.eclipse.jgit.errors.NotSupportedException;
import org.eclipse.jgit.errors.PackProtocolException;
import org.eclipse.jgit.errors.TooLargeObjectInPackException;
import org.eclipse.jgit.errors.TooLargePackException;
import org.eclipse.jgit.errors.TransportException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.internal.storage.pack.PackWriter;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.transport.BasePackConnection;
import org.eclipse.jgit.transport.PackTransport;
import org.eclipse.jgit.transport.PacketLineIn;
import org.eclipse.jgit.transport.PushConnection;
import org.eclipse.jgit.transport.RemoteRefUpdate;
import org.eclipse.jgit.transport.SideBandInputStream;

public abstract class BasePackPushConnection
extends BasePackConnection
implements PushConnection {
    public static final String CAPABILITY_REPORT_STATUS = "report-status";
    public static final String CAPABILITY_DELETE_REFS = "delete-refs";
    public static final String CAPABILITY_OFS_DELTA = "ofs-delta";
    public static final String CAPABILITY_SIDE_BAND_64K = "side-band-64k";
    public static final String CAPABILITY_PUSH_OPTIONS = "push-options";
    private final boolean thinPack;
    private final boolean atomic;
    private List<String> pushOptions;
    private boolean capableAtomic;
    private boolean capableDeleteRefs;
    private boolean capableReport;
    private boolean capableSideBand;
    private boolean capableOfsDelta;
    private boolean capablePushOptions;
    private boolean sentCommand;
    private boolean writePack;
    private long packTransferTime;

    public BasePackPushConnection(PackTransport packTransport) {
        super(packTransport);
        this.thinPack = this.transport.isPushThin();
        this.atomic = this.transport.isPushAtomic();
        this.pushOptions = this.transport.getPushOptions();
    }

    @Override
    public void push(ProgressMonitor monitor, Map<String, RemoteRefUpdate> refUpdates) throws TransportException {
        this.push(monitor, refUpdates, null);
    }

    @Override
    public void push(ProgressMonitor monitor, Map<String, RemoteRefUpdate> refUpdates, OutputStream outputStream) throws TransportException {
        this.markStartedOperation();
        this.doPush(monitor, refUpdates, outputStream);
    }

    @Override
    protected TransportException noRepository(Throwable cause) {
        TransportException te;
        try {
            this.transport.openFetch().close();
            te = new TransportException(this.uri, JGitText.get().pushNotPermitted);
        }
        catch (NoRemoteRepositoryException e) {
            te = e;
        }
        catch (NotSupportedException | TransportException e) {
            te = new TransportException(this.uri, JGitText.get().pushNotPermitted, e);
        }
        te.addSuppressed(cause);
        return te;
    }

    protected void doPush(ProgressMonitor monitor, Map<String, RemoteRefUpdate> refUpdates, OutputStream outputStream) throws TransportException {
        try {
            try {
                this.writeCommands(refUpdates.values(), monitor, outputStream);
                if (this.pushOptions != null && this.capablePushOptions) {
                    this.transmitOptions();
                }
                if (this.writePack) {
                    this.writePack(refUpdates, monitor);
                }
                if (this.sentCommand) {
                    int b;
                    if (this.capableReport) {
                        this.readStatusReport(refUpdates);
                    }
                    if (this.capableSideBand && (b = this.in.read()) >= 0) {
                        throw new TransportException(this.uri, MessageFormat.format(JGitText.get().expectedEOFReceived, Character.valueOf((char)b)));
                    }
                }
            }
            catch (TransportException e) {
                throw e;
            }
            catch (Exception e) {
                throw new TransportException(this.uri, e.getMessage(), e);
            }
        }
        finally {
            this.close();
        }
    }

    private void writeCommands(Collection<RemoteRefUpdate> refUpdates, ProgressMonitor monitor, OutputStream outputStream) throws IOException {
        String capabilities = this.enableCapabilities(monitor, outputStream);
        if (this.atomic && !this.capableAtomic) {
            throw new TransportException(this.uri, JGitText.get().atomicPushNotSupported);
        }
        if (this.pushOptions != null && !this.capablePushOptions) {
            throw new TransportException(this.uri, MessageFormat.format(JGitText.get().pushOptionsNotSupported, this.pushOptions.toString()));
        }
        for (RemoteRefUpdate rru : refUpdates) {
            if (!this.capableDeleteRefs && rru.isDelete()) {
                rru.setStatus(RemoteRefUpdate.Status.REJECTED_NODELETE);
                continue;
            }
            StringBuilder sb = new StringBuilder();
            ObjectId oldId = rru.getExpectedOldObjectId();
            if (oldId == null) {
                Ref advertised = this.getRef(rru.getRemoteName());
                ObjectId objectId = oldId = advertised != null ? advertised.getObjectId() : null;
                if (oldId == null) {
                    oldId = ObjectId.zeroId();
                }
            }
            sb.append(oldId.name());
            sb.append(' ');
            sb.append(rru.getNewObjectId().name());
            sb.append(' ');
            sb.append(rru.getRemoteName());
            if (!this.sentCommand) {
                this.sentCommand = true;
                sb.append(capabilities);
            }
            this.pckOut.writeString(sb.toString());
            rru.setStatus(RemoteRefUpdate.Status.AWAITING_REPORT);
            if (rru.isDelete()) continue;
            this.writePack = true;
        }
        if (monitor.isCancelled()) {
            throw new TransportException(this.uri, JGitText.get().pushCancelled);
        }
        this.pckOut.end();
        this.outNeedsEnd = false;
    }

    private void transmitOptions() throws IOException {
        for (String pushOption : this.pushOptions) {
            this.pckOut.writeString(pushOption);
        }
        this.pckOut.end();
    }

    private String enableCapabilities(ProgressMonitor monitor, OutputStream outputStream) {
        StringBuilder line = new StringBuilder();
        if (this.atomic) {
            this.capableAtomic = this.wantCapability(line, "atomic");
        }
        this.capableReport = this.wantCapability(line, CAPABILITY_REPORT_STATUS);
        this.capableDeleteRefs = this.wantCapability(line, CAPABILITY_DELETE_REFS);
        this.capableOfsDelta = this.wantCapability(line, CAPABILITY_OFS_DELTA);
        if (this.pushOptions != null) {
            this.capablePushOptions = this.wantCapability(line, CAPABILITY_PUSH_OPTIONS);
        }
        this.capableSideBand = this.wantCapability(line, CAPABILITY_SIDE_BAND_64K);
        if (this.capableSideBand) {
            this.in = new SideBandInputStream(this.in, monitor, this.getMessageWriter(), outputStream);
            this.pckIn = new PacketLineIn(this.in);
        }
        this.addUserAgentCapability(line);
        if (line.length() > 0) {
            line.setCharAt(0, '\u0000');
        }
        return line.toString();
    }

    /*
     * WARNING - void declaration
     */
    private void writePack(Map<String, RemoteRefUpdate> refUpdates, ProgressMonitor monitor) throws IOException {
        HashSet<ObjectId> remoteObjects = new HashSet<ObjectId>();
        HashSet<ObjectId> newObjects = new HashSet<ObjectId>();
        Throwable throwable = null;
        Object var6_7 = null;
        try (PackWriter writer = new PackWriter(this.transport.getPackConfig(), this.local.newObjectReader());){
            void var8_16;
            for (Ref ref : this.getRefs()) {
                ObjectId oid = ref.getObjectId();
                if (!this.local.getObjectDatabase().has(oid)) continue;
                remoteObjects.add(oid);
            }
            remoteObjects.addAll(this.additionalHaves);
            for (RemoteRefUpdate remoteRefUpdate : refUpdates.values()) {
                if (ObjectId.zeroId().equals(remoteRefUpdate.getNewObjectId())) continue;
                newObjects.add(remoteRefUpdate.getNewObjectId());
            }
            writer.setIndexDisabled(true);
            writer.setUseCachedPacks(true);
            writer.setUseBitmaps(true);
            writer.setThin(this.thinPack);
            writer.setReuseValidatingObjects(false);
            writer.setDeltaBaseAsOffset(this.capableOfsDelta);
            writer.preparePack(monitor, newObjects, remoteObjects);
            OutputStream outputStream = this.out;
            if (this.capableSideBand) {
                CheckingSideBandOutputStream checkingSideBandOutputStream = new CheckingSideBandOutputStream(this.in, this.out);
            }
            writer.writePack(monitor, monitor, (OutputStream)var8_16);
            this.packTransferTime = writer.getStatistics().getTimeWriting();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void readStatusReport(Map<String, RemoteRefUpdate> refUpdates) throws IOException {
        String unpackLine = this.readStringLongTimeout();
        if (!unpackLine.startsWith("unpack ")) {
            throw new PackProtocolException(this.uri, MessageFormat.format(JGitText.get().unexpectedReportLine, unpackLine));
        }
        String unpackStatus = unpackLine.substring("unpack ".length());
        if (unpackStatus.startsWith("error Pack exceeds the limit of")) {
            throw new TooLargePackException(this.uri, unpackStatus.substring("error ".length()));
        }
        if (unpackStatus.startsWith("error Object too large")) {
            throw new TooLargeObjectInPackException(this.uri, unpackStatus.substring("error ".length()));
        }
        if (!unpackStatus.equals("ok")) {
            throw new TransportException(this.uri, MessageFormat.format(JGitText.get().errorOccurredDuringUnpackingOnTheRemoteEnd, unpackStatus));
        }
        for (String refLine : this.pckIn.readStrings()) {
            boolean ok = false;
            int refNameEnd = -1;
            if (refLine.startsWith("ok ")) {
                ok = true;
                refNameEnd = refLine.length();
            } else if (refLine.startsWith("ng ")) {
                ok = false;
                refNameEnd = refLine.indexOf(32, 3);
            }
            if (refNameEnd == -1) {
                throw new PackProtocolException(MessageFormat.format(JGitText.get().unexpectedReportLine2, this.uri, refLine));
            }
            String refName = refLine.substring(3, refNameEnd);
            String message = ok ? null : refLine.substring(refNameEnd + 1);
            RemoteRefUpdate rru = refUpdates.get(refName);
            if (rru == null) {
                throw new PackProtocolException(MessageFormat.format(JGitText.get().unexpectedRefReport, this.uri, refName));
            }
            if (ok) {
                rru.setStatus(RemoteRefUpdate.Status.OK);
                continue;
            }
            rru.setStatus(RemoteRefUpdate.Status.REJECTED_OTHER_REASON);
            rru.setMessage(message);
        }
        for (RemoteRefUpdate rru : refUpdates.values()) {
            if (rru.getStatus() != RemoteRefUpdate.Status.AWAITING_REPORT) continue;
            throw new PackProtocolException(MessageFormat.format(JGitText.get().expectedReportForRefNotReceived, this.uri, rru.getRemoteName()));
        }
    }

    private String readStringLongTimeout() throws IOException {
        if (this.timeoutIn == null) {
            return this.pckIn.readString();
        }
        int oldTimeout = this.timeoutIn.getTimeout();
        int sendTime = (int)Math.min(this.packTransferTime, 28800000L);
        try {
            int timeout = 10 * Math.max(sendTime, oldTimeout);
            this.timeoutIn.setTimeout(timeout < 0 ? Integer.MAX_VALUE : timeout);
            String string = this.pckIn.readString();
            return string;
        }
        finally {
            this.timeoutIn.setTimeout(oldTimeout);
        }
    }

    public List<String> getPushOptions() {
        return this.pushOptions;
    }

    private static class CheckingSideBandOutputStream
    extends OutputStream {
        private final InputStream in;
        private final OutputStream out;

        CheckingSideBandOutputStream(InputStream in, OutputStream out) {
            this.in = in;
            this.out = out;
        }

        @Override
        public void write(int b) throws IOException {
            this.write(new byte[]{(byte)b});
        }

        @Override
        public void write(byte[] buf, int ptr, int cnt) throws IOException {
            try {
                this.out.write(buf, ptr, cnt);
            }
            catch (IOException e) {
                throw this.checkError(e);
            }
        }

        @Override
        public void flush() throws IOException {
            try {
                this.out.flush();
            }
            catch (IOException e) {
                throw this.checkError(e);
            }
        }

        private IOException checkError(IOException e1) {
            try {
                this.in.read();
            }
            catch (TransportException e2) {
                return e2;
            }
            catch (IOException e2) {
                return e1;
            }
            return e1;
        }
    }
}

