/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp;

import java.io.IOException;
import java.util.ArrayList;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Range;
import ucar.ma2.Section;
import ucar.nc2.iosp.IndexChunker;
import ucar.nc2.iosp.IndexChunkerTiled;
import ucar.nc2.iosp.Layout;

public class LayoutTiled
implements Layout {
    private Section want;
    private int[] chunkSize;
    private int elemSize;
    private long startSrcPos;
    private DataChunkIterator chunkIterator;
    private IndexChunkerTiled index = null;
    private long totalNelems;
    private long totalNelemsDone;
    private static final boolean debug = false;
    private static final boolean debugNext = false;
    private Layout.Chunk next = null;

    public LayoutTiled(DataChunkIterator chunkIterator, int[] chunkSize, int elemSize, Section wantSection) throws InvalidRangeException, IOException {
        this.chunkIterator = chunkIterator;
        this.chunkSize = chunkSize;
        this.elemSize = elemSize;
        this.want = wantSection;
        if (this.want.isVariableLength()) {
            ArrayList<Range> newrange = new ArrayList<Range>(this.want.getRanges());
            newrange.remove(newrange.size() - 1);
            this.want = new Section(newrange);
        }
        this.totalNelems = this.want.computeSize();
        this.totalNelemsDone = 0L;
    }

    @Override
    public long getTotalNelems() {
        return this.totalNelems;
    }

    @Override
    public int getElemSize() {
        return this.elemSize;
    }

    @Override
    public boolean hasNext() {
        if (this.totalNelemsDone >= this.totalNelems) {
            return false;
        }
        if (this.index == null || !this.index.hasNext()) {
            try {
                DataChunk dataChunk;
                Section dataSection;
                do {
                    if (!this.chunkIterator.hasNext()) {
                        this.next = null;
                        return false;
                    }
                    try {
                        dataChunk = this.chunkIterator.next();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        this.next = null;
                        return false;
                    }
                } while (!(dataSection = new Section(dataChunk.offset, this.chunkSize)).intersects(this.want));
                this.index = new IndexChunkerTiled(dataSection, this.want);
                this.startSrcPos = dataChunk.filePos;
            }
            catch (InvalidRangeException e) {
                throw new IllegalStateException(e);
            }
        }
        IndexChunker.Chunk chunk = this.index.next();
        this.totalNelemsDone += (long)chunk.getNelems();
        chunk.setSrcPos(this.startSrcPos + chunk.getSrcElem() * (long)this.elemSize);
        this.next = chunk;
        return true;
    }

    @Override
    public Layout.Chunk next() throws IOException {
        return this.next;
    }

    public String toString() {
        StringBuilder sbuff = new StringBuilder();
        sbuff.append("want=").append(this.want).append("; ");
        sbuff.append("chunkSize=[");
        for (int i = 0; i < this.chunkSize.length; ++i) {
            if (i > 0) {
                sbuff.append(",");
            }
            sbuff.append(this.chunkSize[i]);
        }
        sbuff.append("] totalNelems=").append(this.totalNelems);
        sbuff.append(" elemSize=").append(this.elemSize);
        return sbuff.toString();
    }

    public static class DataChunk {
        public int[] offset;
        public long filePos;

        public DataChunk(int[] offset, long filePos) {
            this.offset = offset;
            this.filePos = filePos;
        }
    }

    public static interface DataChunkIterator {
        public boolean hasNext();

        public DataChunk next() throws IOException;
    }
}

