/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.coordsys;

import java.io.IOException;
import java.util.List;
import ucar.ma2.Array;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Section;
import ucar.nc2.Dimension;
import ucar.nc2.Variable;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.CoordinateSystem;

public class GeoReferencingCoordSys {
    private CoordinateSystem cs;

    public GeoReferencingCoordSys(CoordinateSystem cs) {
        this.cs = cs;
    }

    public double readLatitudeCoord(Variable fromVar, int[] index) throws IOException, InvalidRangeException {
        CoordinateAxis axis = this.cs.getLatAxis();
        if (null == axis) {
            throw new IllegalArgumentException("There is no latitude coordinate");
        }
        return this.readValue(axis, fromVar, index);
    }

    public double readLongitudeCoord(Variable fromVar, int[] index) throws IOException, InvalidRangeException {
        CoordinateAxis axis = this.cs.getLonAxis();
        if (null == axis) {
            throw new IllegalArgumentException("There is no longiude coordinate");
        }
        return this.readValue(axis, fromVar, index);
    }

    public double readPressureCoord(Variable fromVar, int[] index) throws IOException, InvalidRangeException {
        CoordinateAxis axis = this.cs.getPressureAxis();
        if (null == axis) {
            throw new IllegalArgumentException("There is no pressure coordinate");
        }
        return this.readValue(axis, fromVar, index);
    }

    public double readHeightCoord(Variable fromVar, int[] index) throws IOException, InvalidRangeException {
        CoordinateAxis axis = this.cs.getHeightAxis();
        if (null == axis) {
            throw new IllegalArgumentException("There is no height coordinate");
        }
        return this.readValue(axis, fromVar, index);
    }

    public double readTimeCoord(Variable fromVar, int[] index) throws IOException, InvalidRangeException {
        CoordinateAxis axis = this.cs.getTaxis();
        if (null == axis) {
            throw new IllegalArgumentException("There is no time coordinate");
        }
        return this.readValue(axis, fromVar, index);
    }

    public double readGeoXCoord(Variable fromVar, int[] index) throws IOException, InvalidRangeException {
        CoordinateAxis axis = this.cs.getXaxis();
        if (null == axis) {
            throw new IllegalArgumentException("There is no GeoX coordinate");
        }
        return this.readValue(axis, fromVar, index);
    }

    public double readGeoYCoord(Variable fromVar, int[] index) throws IOException, InvalidRangeException {
        CoordinateAxis axis = this.cs.getYaxis();
        if (null == axis) {
            throw new IllegalArgumentException("There is no GeoY coordinate");
        }
        return this.readValue(axis, fromVar, index);
    }

    public double readGeoZCoord(Variable fromVar, int[] index) throws IOException, InvalidRangeException {
        CoordinateAxis axis = this.cs.getZaxis();
        if (null == axis) {
            throw new IllegalArgumentException("There is no GeoZ coordinate");
        }
        return this.readValue(axis, fromVar, index);
    }

    public double readValue(Variable targetVar, Variable fromVar, int[] index) throws InvalidRangeException, IOException {
        Section axisElement = this.mapIndex(targetVar, fromVar, index);
        Array result = targetVar.read(axisElement);
        return result.nextDouble();
    }

    public Section mapIndex(Variable targetVar, Variable fromVar, int[] fromIndex) throws InvalidRangeException {
        List<Dimension> toDims = targetVar.getDimensions();
        List<Dimension> fromDims = fromVar.getDimensions();
        Section result = new Section();
        for (int i = 0; i < toDims.size(); ++i) {
            Dimension dim = toDims.get(i);
            int varIndex = fromDims.indexOf(toDims.get(i));
            if (varIndex < 0) {
                throw new IllegalArgumentException("Dimension " + dim + " does not exist");
            }
            result.appendRange(fromIndex[varIndex], fromIndex[varIndex]);
        }
        return result;
    }
}

