/*
 * Decompiled with CFR 0.152.
 */
package org.h2.index;

import org.h2.index.Cursor;
import org.h2.index.TreeIndex;
import org.h2.index.TreeNode;
import org.h2.result.Row;
import org.h2.result.SearchRow;

public class TreeCursor
implements Cursor {
    private TreeIndex tree;
    private TreeNode node;
    private boolean beforeFirst;
    private SearchRow first;
    private SearchRow last;

    TreeCursor(TreeIndex treeIndex, TreeNode treeNode, SearchRow searchRow, SearchRow searchRow2) {
        this.tree = treeIndex;
        this.node = treeNode;
        this.first = searchRow;
        this.last = searchRow2;
        this.beforeFirst = true;
    }

    public Row get() {
        return this.node == null ? null : this.node.row;
    }

    public SearchRow getSearchRow() {
        return this.get();
    }

    public boolean next() {
        if (this.beforeFirst) {
            this.beforeFirst = false;
            if (this.node == null) {
                return false;
            }
            if (this.first != null && this.tree.compareRows(this.node.row, this.first) < 0) {
                this.node = TreeCursor.next(this.node);
            }
        } else {
            this.node = TreeCursor.next(this.node);
        }
        if (this.node != null && this.last != null && this.tree.compareRows(this.node.row, this.last) > 0) {
            this.node = null;
        }
        return this.node != null;
    }

    public boolean previous() {
        this.node = TreeCursor.previous(this.node);
        return this.node != null;
    }

    private static TreeNode next(TreeNode treeNode) {
        if (treeNode == null) {
            return null;
        }
        TreeNode treeNode2 = treeNode.right;
        if (treeNode2 != null) {
            treeNode = treeNode2;
            TreeNode treeNode3 = treeNode.left;
            while (treeNode3 != null) {
                treeNode = treeNode3;
                treeNode3 = treeNode.left;
            }
            return treeNode;
        }
        TreeNode treeNode4 = treeNode;
        treeNode = treeNode.parent;
        while (treeNode != null && treeNode4 == treeNode.right) {
            treeNode4 = treeNode;
            treeNode = treeNode.parent;
        }
        return treeNode;
    }

    private static TreeNode previous(TreeNode treeNode) {
        if (treeNode == null) {
            return null;
        }
        TreeNode treeNode2 = treeNode.left;
        if (treeNode2 != null) {
            treeNode = treeNode2;
            TreeNode treeNode3 = treeNode.right;
            while (treeNode3 != null) {
                treeNode = treeNode3;
                treeNode3 = treeNode.right;
            }
            return treeNode;
        }
        TreeNode treeNode4 = treeNode;
        treeNode = treeNode.parent;
        while (treeNode != null && treeNode4 == treeNode.left) {
            treeNode4 = treeNode;
            treeNode = treeNode.parent;
        }
        return treeNode;
    }
}

