/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.namefind;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import opennlp.tools.namefind.NameFinderSequenceValidator;
import opennlp.tools.util.SequenceCodec;
import opennlp.tools.util.Span;

public class BioCodec
implements SequenceCodec<String> {
    public static final String START = "start";
    public static final String CONTINUE = "cont";
    public static final String OTHER = "other";
    private static final Pattern typedOutcomePattern = Pattern.compile("(.+)-\\w+");

    static String extractNameType(String outcome) {
        Matcher matcher = typedOutcomePattern.matcher(outcome);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return null;
    }

    @Override
    public Span[] decode(List<String> c) {
        int start = -1;
        int end = -1;
        ArrayList<Span> spans = new ArrayList<Span>(c.size());
        for (int li = 0; li < c.size(); ++li) {
            String chunkTag = c.get(li);
            if (chunkTag.endsWith(START)) {
                if (start != -1) {
                    spans.add(new Span(start, end, BioCodec.extractNameType(c.get(li - 1))));
                }
                start = li;
                end = li + 1;
                continue;
            }
            if (chunkTag.endsWith(CONTINUE)) {
                end = li + 1;
                continue;
            }
            if (!chunkTag.endsWith(OTHER) || start == -1) continue;
            spans.add(new Span(start, end, BioCodec.extractNameType(c.get(li - 1))));
            start = -1;
            end = -1;
        }
        if (start != -1) {
            spans.add(new Span(start, end, BioCodec.extractNameType(c.get(c.size() - 1))));
        }
        return spans.toArray(new Span[spans.size()]);
    }

    public String[] encode(Span[] names, int length) {
        Object[] outcomes = new String[length];
        Arrays.fill(outcomes, OTHER);
        for (Span name : names) {
            outcomes[name.getStart()] = name.getType() == null ? "default-start" : name.getType() + "-" + START;
            for (int i = name.getStart() + 1; i < name.getEnd(); ++i) {
                outcomes[i] = name.getType() == null ? "default-cont" : name.getType() + "-" + CONTINUE;
            }
        }
        return outcomes;
    }

    public NameFinderSequenceValidator createSequenceValidator() {
        return new NameFinderSequenceValidator();
    }

    @Override
    public boolean areOutcomesCompatible(String[] outcomes) {
        ArrayList<String> start = new ArrayList<String>();
        ArrayList<String> cont = new ArrayList<String>();
        for (String outcome : outcomes) {
            if (outcome.endsWith(START)) {
                start.add(outcome.substring(0, outcome.length() - START.length()));
                continue;
            }
            if (outcome.endsWith(CONTINUE)) {
                cont.add(outcome.substring(0, outcome.length() - CONTINUE.length()));
                continue;
            }
            if (outcome.equals(OTHER)) continue;
            return false;
        }
        if (start.size() == 0) {
            return false;
        }
        for (String contPreffix : cont) {
            if (start.contains(contPreffix)) continue;
            return false;
        }
        return true;
    }
}

