/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.common.util;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.solr.common.util.Utils;
import org.apache.solr.common.util.Validator;

class OneOfValidator
extends Validator<List<String>> {
    private Set<String> oneOfProps;

    OneOfValidator(Map<?, ?> schema, List<String> oneOfProps) {
        super(schema, oneOfProps);
        this.oneOfProps = new HashSet<String>(oneOfProps);
    }

    @Override
    boolean validate(Object o, List<String> errs) {
        if (o instanceof Map) {
            Map map = (Map)o;
            for (Object key : map.keySet()) {
                if (!this.oneOfProps.contains(key.toString())) continue;
                return true;
            }
            errs.add("One of fields :" + this.oneOfProps + " is not presented in object : " + Utils.toJSONString(o));
            return false;
        }
        return false;
    }
}

