/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.common.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.function.Predicate;
import java.util.zip.GZIPInputStream;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.request.RequestWriter;
import org.apache.solr.common.util.ContentStream;

public abstract class ContentStreamBase
implements ContentStream {
    public static final String DEFAULT_CHARSET = StandardCharsets.UTF_8.name();
    private static final String TEXT_CSV = "text/csv";
    public static final String TEXT_XML = "text/xml";
    public static final String APPLICATION_OCTET_STREAM = "application/octet-stream";
    public static final String APPLICATION_GZIP = "application/gzip";
    public static final String APPLICATION_XML = "application/xml";
    public static final String APPLICATION_JSON = "application/json";
    private static final List<String> UNHELPFUL_TYPES = Arrays.asList("application/octet-stream", "application/gzip", "content/unknown");
    private static final List<String> XML_SUF = Arrays.asList(".xml", ".xml.gz", ".xml.gzip");
    private static final List<String> JSON_SUF = Arrays.asList(".json", ".json.gz", ".json.gzip");
    private static final List<String> CSV_SUF = Arrays.asList(".csv", ".csv.gz", ".csv.gzip");
    protected String name;
    protected String sourceInfo;
    protected String contentType;
    protected Long size;

    public static String getCharsetFromContentType(String contentType) {
        int idx;
        if (contentType != null && (idx = contentType.toLowerCase(Locale.ROOT).indexOf("charset=")) > 0) {
            return contentType.substring(idx + "charset=".length()).trim();
        }
        return null;
    }

    protected String attemptToDetermineContentType() {
        String type = null;
        if (this.name != null) {
            Predicate<String> endsWith = suffix -> this.name.toLowerCase(Locale.ROOT).endsWith((String)suffix);
            type = XML_SUF.stream().anyMatch(endsWith) ? APPLICATION_XML : (JSON_SUF.stream().anyMatch(endsWith) ? APPLICATION_JSON : (CSV_SUF.stream().anyMatch(endsWith) ? TEXT_CSV : this.attemptToDetermineTypeFromFirstCharacter()));
        }
        return type;
    }

    private String attemptToDetermineTypeFromFirstCharacter() {
        String type = null;
        try (InputStream stream = this.getStream();){
            int data = stream.read();
            while (data != -1 && (char)data == ' ') {
                data = stream.read();
            }
            if ((char)data == '<') {
                type = APPLICATION_XML;
            } else if ((char)data == '{') {
                type = APPLICATION_JSON;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return type;
    }

    @Override
    public Reader getReader() throws IOException {
        String charset = ContentStreamBase.getCharsetFromContentType(this.getContentType());
        return charset == null ? new InputStreamReader(this.getStream(), DEFAULT_CHARSET) : new InputStreamReader(this.getStream(), charset);
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public Long getSize() {
        return this.size;
    }

    public void setSize(Long size) {
        this.size = size;
    }

    @Override
    public String getSourceInfo() {
        return this.sourceInfo;
    }

    public void setSourceInfo(String sourceInfo) {
        this.sourceInfo = sourceInfo;
    }

    public static ContentStream create(RequestWriter requestWriter, SolrRequest req) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        RequestWriter.ContentWriter contentWriter = requestWriter.getContentWriter(req);
        contentWriter.write(baos);
        return new ByteArrayStream(baos.toByteArray(), null, contentWriter.getContentType());
    }

    public static class ByteArrayStream
    extends ContentStreamBase {
        private final byte[] bytes;

        public ByteArrayStream(byte[] bytes, String source) {
            this(bytes, source, null);
        }

        public ByteArrayStream(byte[] bytes, String source, String contentType) {
            this.bytes = bytes;
            this.contentType = contentType;
            this.name = source;
            this.size = bytes.length;
            this.sourceInfo = source;
        }

        @Override
        public InputStream getStream() throws IOException {
            return new ByteArrayInputStream(this.bytes);
        }
    }

    public static class StringStream
    extends ContentStreamBase {
        private final String str;

        public StringStream(String str) {
            this(str, StringStream.detect(str));
        }

        public StringStream(String str, String contentType) {
            this.str = str;
            this.contentType = contentType;
            this.name = null;
            try {
                this.size = str.getBytes(DEFAULT_CHARSET).length;
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
            this.sourceInfo = "string";
        }

        public static String detect(String str) {
            String detectedContentType = null;
            int lim = str.length() - 1;
            for (int i = 0; i < lim; ++i) {
                char ch = str.charAt(i);
                if (Character.isWhitespace(ch)) continue;
                if (ch == '#' || ch == '/' && (str.charAt(i + 1) == '/' || str.charAt(i + 1) == '*') || ch == '{' || ch == '[') {
                    detectedContentType = ContentStreamBase.APPLICATION_JSON;
                    break;
                }
                if (ch != '<') break;
                detectedContentType = ContentStreamBase.TEXT_XML;
                break;
            }
            return detectedContentType;
        }

        @Override
        public InputStream getStream() throws IOException {
            return new ByteArrayInputStream(this.str.getBytes(DEFAULT_CHARSET));
        }

        @Override
        public Reader getReader() throws IOException {
            String charset = StringStream.getCharsetFromContentType(this.contentType);
            return charset == null ? new StringReader(this.str) : new InputStreamReader(this.getStream(), charset);
        }
    }

    public static class FileStream
    extends ContentStreamBase {
        private final File file;

        public FileStream(File f) {
            this.file = f;
            this.contentType = null;
            this.name = this.file.getName();
            this.size = this.file.length();
            this.sourceInfo = this.file.toURI().toString();
        }

        @Override
        public String getContentType() {
            if (this.contentType == null) {
                this.contentType = this.attemptToDetermineContentType();
            }
            return this.contentType;
        }

        @Override
        public InputStream getStream() throws IOException {
            InputStream is = new FileInputStream(this.file);
            String lowerName = this.name.toLowerCase(Locale.ROOT);
            if (lowerName.endsWith(".gz") || lowerName.endsWith(".gzip")) {
                is = new GZIPInputStream(is);
            }
            return is;
        }
    }

    public static class URLStream
    extends ContentStreamBase {
        private final URL url;

        public URLStream(URL url) {
            this.url = url;
            this.sourceInfo = "url";
        }

        @Override
        public String getContentType() {
            if ("file".equals(this.url.getProtocol())) {
                Predicate<String> equals = mimeType -> mimeType.equals(this.contentType);
                if (UNHELPFUL_TYPES.stream().anyMatch(equals)) {
                    String type = this.attemptToDetermineContentType();
                    this.contentType = type != null ? type : this.contentType;
                }
            }
            return this.contentType;
        }

        @Override
        public InputStream getStream() throws IOException {
            URLConnection conn = this.url.openConnection();
            this.contentType = conn.getContentType();
            this.name = this.url.toExternalForm();
            this.size = conn.getContentLengthLong();
            InputStream is = conn.getInputStream();
            String urlFile = this.url.getFile().toLowerCase(Locale.ROOT);
            if ("gzip".equals(conn.getContentEncoding()) || urlFile.endsWith(".gz") || urlFile.endsWith(".gzip")) {
                is = new GZIPInputStream(is);
            }
            return is;
        }
    }
}

