/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.feature.j2d;

import java.awt.Shape;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.sis.internal.feature.j2d.MultiPolylines;
import org.apache.sis.internal.feature.j2d.Polygon;
import org.apache.sis.internal.feature.j2d.Polyline;
import org.opengis.referencing.operation.TransformException;

public class PathBuilder {
    private static final int DIMENSION = 2;
    private double[] coordinates = new double[100];
    private int size;
    private final List<Polyline> polylines = new ArrayList<Polyline>();

    private boolean isValidSize(int n) {
        return this.size >= 0 && this.size <= n && (this.size & 1) == 0;
    }

    public final void append(PathBuilder pathBuilder) {
        if (pathBuilder != null) {
            assert (pathBuilder.size == 0);
            this.polylines.addAll(pathBuilder.polylines);
        }
    }

    public final void append(double[] dArray, int n, boolean bl) throws TransformException {
        double d;
        double d2;
        assert (n >= 0 && (n & 1) == 0) : n;
        int n2 = this.size;
        if (n >= this.coordinates.length - n2) {
            this.coordinates = Arrays.copyOf(this.coordinates, Math.addExact(n2, Math.max(n2, n)));
        }
        double[] dArray2 = this.coordinates;
        if (n2 != 0) {
            d2 = dArray2[n2 - 2];
            d = dArray2[n2 - 1];
        } else {
            d = Double.NaN;
            d2 = Double.NaN;
        }
        int n3 = 0;
        while (n3 < n) {
            double d3;
            double d4;
            if (bl) {
                d4 = dArray[n - ++n3];
                d3 = dArray[n - ++n3];
            } else {
                d3 = dArray[n3++];
                d4 = dArray[n3++];
            }
            if (d3 == d2 && d4 == d) continue;
            if (Double.isNaN(d3) || Double.isNaN(d4)) {
                if (n2 != 0) {
                    this.size = this.filterChunk(dArray2, this.size, n2);
                    assert (this.isValidSize(n2)) : this.size;
                    this.createPolyline(false);
                    n2 = 0;
                }
            } else {
                dArray2[n2++] = d3;
                dArray2[n2++] = d4;
            }
            d2 = d3;
            d = d4;
        }
        this.size = this.filterChunk(dArray2, this.size, n2);
        assert (this.isValidSize(n2)) : this.size;
    }

    protected int filterChunk(double[] dArray, int n, int n2) {
        return n2;
    }

    protected int filterFull(double[] dArray, int n) throws TransformException {
        return n;
    }

    public final void createPolyline(boolean bl) throws TransformException {
        this.size = this.filterFull(this.coordinates, this.size);
        assert (this.isValidSize(this.coordinates.length)) : this.size;
        if (this.size >= 4) {
            if (this.coordinates[0] == this.coordinates[this.size - 2] && this.coordinates[1] == this.coordinates[this.size - 1]) {
                this.size -= 2;
                bl = true;
            }
            this.polylines.add(bl ? new Polygon(this.coordinates, this.size) : new Polyline(this.coordinates, this.size));
        }
        this.size = 0;
    }

    public final Shape build() {
        switch (this.polylines.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return this.polylines.get(0);
            }
        }
        return new MultiPolylines(this.polylines.toArray(new Polyline[this.polylines.size()]));
    }

    public String toString() {
        return PathBuilder.toString(this.coordinates, this.size);
    }

    public static String toString(double[] dArray, int n) {
        StringBuilder stringBuilder = new StringBuilder(30).append('[');
        if (n >= 2) {
            stringBuilder.append((float)dArray[0]).append(", ").append((float)dArray[1]);
            int n2 = n - 2;
            if (n2 >= 2) {
                stringBuilder.append(", ");
                if (n >= 6) {
                    stringBuilder.append(" \u2026 (").append(n / 2 - 2).append(" pts) \u2026 ");
                }
                stringBuilder.append((float)dArray[n2]).append(", ").append((float)dArray[n2 + 1]);
            }
        }
        return stringBuilder.append(']').toString();
    }
}

