/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.index.tree;

import java.io.Serializable;
import java.util.Arrays;

abstract class PointTreeNode
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -5911043832415017844L;

    PointTreeNode() {
    }

    static int quadrant(double[] dArray, double[] dArray2) {
        int n = 0;
        int n2 = dArray2.length >>> 1;
        while (--n2 >= 0) {
            if (!(dArray[n2] < dArray2[n2])) continue;
            n |= 1 << n2;
        }
        return n;
    }

    static void enterQuadrant(double[] dArray, int n) {
        int n2;
        int n3 = n2 = dArray.length >>> 1;
        while (--n3 >= 0) {
            int n4 = n3;
            int n5 = n3 + n2;
            double d = dArray[n5] * 0.5;
            dArray[n5] = d;
            dArray[n4] = dArray[n4] + PointTreeNode.factor(n, n3) * d;
        }
    }

    static double factor(int n, int n2) {
        return Double.longBitsToDouble(0x3FE0000000000000L | (long)(n & 1 << n2) << 63 - n2);
    }

    abstract void clear();

    abstract Object getChild(int var1);

    abstract void setChild(int var1, Object var2);

    abstract PointTreeNode newInstance();

    protected Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new AssertionError((Object)cloneNotSupportedException);
        }
    }

    static final class Default
    extends PointTreeNode {
        private static final long serialVersionUID = 5726750714534959859L;
        private final Object[] children;

        Default(int n) {
            this.children = new Object[n];
        }

        private Default(Default default_) {
            this.children = (Object[])default_.children.clone();
            for (int i = 0; i < this.children.length; ++i) {
                Object object = this.children[i];
                if (!(object instanceof PointTreeNode)) continue;
                this.children[i] = ((PointTreeNode)object).clone();
            }
        }

        @Override
        final PointTreeNode newInstance() {
            return new Default(this.children.length);
        }

        @Override
        final void clear() {
            Arrays.fill(this.children, null);
        }

        @Override
        final Object getChild(int n) {
            return this.children[n];
        }

        @Override
        final void setChild(int n, Object object) {
            this.children[n] = object;
        }

        @Override
        protected Object clone() {
            return new Default(this);
        }
    }
}

